/*
 * Decompiled with CFR 0.152.
 */
package com.javanicus.blogmento;

import com.javanicus.blogmento.BlogState;
import com.javanicus.blogmento.Channel;
import com.javanicus.blogmento.DataAccessObject;
import com.javanicus.blogmento.Item;
import com.javanicus.blogmento.Logger;
import com.javanicus.blogmento.PopupLauncher;
import com.javanicus.blogmento.Prefs;
import com.javanicus.blogmento.Style;
import com.javanicus.blogmento.Subject;
import com.javanicus.blogmento.Template;
import com.javanicus.blogmento.TemplateEngine;
import com.javanicus.blogmento.Transport;
import com.javanicus.blogmento.TransportFactory;
import com.javanicus.blogmento.Utilities;
import com.javanicus.blogmento.Wizard;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import thinlet.FrameLauncher;
import thinlet.Thinlet;

public class Blogmento
extends Thinlet {
    private int minYear;
    private int maxYear;
    private String inputPath = "";
    private String outputPath = "";
    private String propertyPath = "";
    private BlogState state;
    private DateFormat df = new SimpleDateFormat("dd MMM kk:mm");

    public Blogmento() {
        Logger.log("Blogmento()");
        this.state = new BlogState();
        this.state.getPrefs().setWorkingDirectory(System.getProperty("user.home"));
        this.outputPath = this.state.getPrefs().getWorkingDirectory() + "/blogmento/channels/";
        this.propertyPath = this.state.getPrefs().getWorkingDirectory() + "/blogmento/";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) {
        Blogmento b = new Blogmento();
        Logger.log("main()");
        for (int i = 0; i < args.length; ++i) {
            Logger.log("args[" + i + "] : " + args[i]);
        }
        if (args.length > 0) {
            try {
                if ("add".equals(args[0]) || "a".equals(args[0])) {
                    if (args.length <= 1) throw new Exception("syntax: blog add [subject]");
                    b.cmdAdd(args[1]);
                } else if ("publish".equals(args[0]) || "p".equals(args[0])) {
                    if (args.length <= 1) throw new Exception("syntax: blog publish [channel]");
                    b.cmdPublish(args[1]);
                } else {
                    b.cmdAdd(args[0]);
                    b.cmdPublish(args[1]);
                }
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                b.badExit();
            }
            b.goodExit();
            return;
        }
        b.getState().setGuiMode(true);
        b.initialise();
        b.initialiseGui();
        new FrameLauncher("Blogmento2 (by jez)", b, 640, 480);
        if (!"http://default-install.com/".equals(b.getState().getCurrentChannel().getLink())) return;
        b.wizardPressed();
    }

    public BlogState getState() {
        return this.state;
    }

    public int getMinYear() {
        return this.minYear;
    }

    public void setMinYear(int minYear) {
        this.minYear = minYear;
    }

    public int getMaxYear() {
        return this.maxYear;
    }

    public void setMaxYear(int maxYear) {
        this.maxYear = maxYear;
    }

    private void goodExit() {
        Logger.log("goodExit()");
        System.exit(0);
    }

    private void badExit() {
        Logger.log("badExit()");
        System.exit(-1);
    }

    private void cmdAdd(String subject) {
        Logger.log("cmdAdd(" + subject + ")");
        String line = "";
        String description = "";
        System.out.println("Enter your " + subject + " blog entry:");
        System.out.println("    Escape character is '.'");
        BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
        try {
            while ((line = input.readLine()) != null && !".".equals(line)) {
                description = description + line + "\n";
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Logger.log("description:'" + description + "'");
        this.initialise();
        Item unsavedItem = this.state.getCurrentItem();
        unsavedItem.setTitle(Utilities.extractTitle(description));
        unsavedItem.setDescription(description);
        Date now = new Date();
        if (unsavedItem.getId() < 0) {
            unsavedItem.setWhen(now);
        }
        unsavedItem.setLastUpdated(now);
        this.state.setSubjects(this.state.getDao().fetchSubjects(null));
        int index = this.findSubject(subject);
        if (index <= -1) {
            throw new RuntimeException("couldn't find subject:" + subject);
        }
        this.state.setCurrentSubject((Subject)this.state.getSubjects().get(index));
        this.state.getDao().saveItem(this.state.getCurrentSubject(), unsavedItem);
    }

    private void cmdPublish(String channel) throws Exception {
        Logger.log("cmdPublish(" + channel + ")");
        System.out.println("Generating " + channel);
        this.initialise();
        this.state.setChannels(this.state.getDao().fetchChannels());
        Iterator itr = this.state.getChannels().iterator();
        while (itr.hasNext()) {
            Channel c = (Channel)itr.next();
            if (!channel.equals(c.getTitle())) continue;
            this.state.setCurrentChannel(c);
            break;
        }
        this.state.setItems(this.state.getDao().fetchItems(this.state.getCurrentChannel()));
        this.state.setSubjects(this.state.getDao().fetchSubjects(this.state.getCurrentChannel()));
        this.state.setTemplates(this.state.getDao().fetchTemplates());
        this.state.setCurrentStyle(this.state.getDao().fetchStyle(this.state.getCurrentChannel()));
        List outputFiles = this.generateChannel();
        System.out.println("Uploading " + channel);
        this.uploadChannel(outputFiles);
        System.out.println("all done.");
    }

    public void initialise() {
        Logger.log("initialise()");
        try {
            if (this.state.getDao() == null) {
                this.state.setDao(new DataAccessObject(this));
                this.state.getDao().getConnection();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void initialiseGui() {
        Logger.log("initialiseGui()");
        try {
            this.add(this.parse("blogmento.xml"));
            this.update();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void update() {
        this.repopulateChannels();
        this.repopulateAllSubjects();
        this.repopulateStyles();
        this.repopulatePrefs();
        this.selectFirstChannel();
        this.selectFirstManageChannel();
        this.selectFirstManageSubject();
    }

    public void itemSelected() {
        Logger.log("itemSelected()");
        int j = this.getSelectedIndex(this.find("items"));
        if (j > -1) {
            this.state.setCurrentItem((Item)this.state.getItems().get(j));
            this.populateItem(this.state.getCurrentItem());
            this.selectCurrentSubject();
        }
    }

    public void transportDetailsSelected() {
        Logger.log("transportDetailsSelected()");
        int j = this.getSelectedIndex(this.find("transportDetails"));
        if (j > -1) {
            Object row = this.getItem(this.find("transportDetails"), "row", j);
            String key = this.getString(this.getItem(row, "cell", 0), "text");
            String value = this.getString(this.getItem(row, "cell", 1), "text");
            this.setString(this.find("transportKey"), "text", key);
            this.setString(this.find("transportValue"), "text", value);
        }
    }

    public void updateTransportValueTypedInto() {
        Object row;
        String key2;
        Logger.log("updateTransportValueTypedInto()");
        String key = this.getString(this.find("transportKey"), "text");
        String value = this.getString(this.find("transportValue"), "text");
        int j = this.getSelectedIndex(this.find("transportDetails"));
        if (j > -1 && key.equals(key2 = this.getString(this.getItem(row = this.getItem(this.find("transportDetails"), "row", j), "cell", 0), "text"))) {
            this.setString(this.getItem(row, "cell", 1), "text", value);
            this.setSelectedIndex(this.find("transportDetails"), j);
        }
    }

    public void channelSelected() {
        Logger.log("channelSelected()");
        int i = this.getSelectedIndex(this.find("channels"));
        if (i > -1) {
            Channel c = (Channel)this.state.getChannels().get(i);
            this.state.setCurrentChannel(c);
            this.state.setCurrentItem(new Item());
            this.repopulateSubjects();
            this.state.setTemplates(this.state.getDao().fetchTemplates());
            this.state.setCurrentStyle(this.state.getDao().fetchStyle(c));
        }
    }

    public void subjectSelected() {
        Logger.log("subjectSelected()");
        int i = this.getSelectedIndex(this.find("subjects"));
        if (i > -1) {
            this.state.setCurrentSubject((Subject)this.state.getSubjects().get(i));
        }
    }

    public void saveItemPressed() {
        Logger.log("saveItemPressed()");
        Item unsavedItem = this.state.getCurrentItem();
        unsavedItem.setTitle(this.getString(this.find("itemTitle"), "text"));
        unsavedItem.setDescription(this.getString(this.find("itemDescription"), "text"));
        Date now = new Date();
        if (unsavedItem.getId() < 0) {
            unsavedItem.setWhen(now);
        }
        unsavedItem.setLastUpdated(now);
        this.state.getDao().saveItem(this.state.getCurrentSubject(), unsavedItem);
    }

    public void newItemPressed() {
        Logger.log("newItemPressed()");
        this.state.setCurrentItem(new Item());
        this.repopulateItem();
    }

    public void newManageSubjectPressed() {
        Logger.log("newManageSubjectPressed()");
        this.state.setManageSubject(new Subject());
        this.populateManageSubject(this.state.getManageSubject());
    }

    public void newManageChannelPressed() {
        Logger.log("newManageChannelPressed()");
        this.state.setManageChannel(new Channel());
        this.populateManageChannel(this.state.getManageChannel());
    }

    public void addSelectedSubjectToChannelPressed() {
        Logger.log("addSelectedSubjectToChannelPressed()");
        Subject subject = this.getSelectedSubject("allSubjects");
        Channel channel = this.getSelectedChannel("addToChannels");
        this.state.getDao().associateSubjectWithChannel(subject, channel);
    }

    private Channel getSelectedChannel(String comboBox) {
        Channel channel = null;
        String cTitle = this.getString(this.find(comboBox), "text");
        Iterator itr = this.state.getChannels().iterator();
        while (itr.hasNext()) {
            Channel cc = (Channel)itr.next();
            if (!cTitle.equals(cc.getTitle())) continue;
            channel = cc;
            break;
        }
        if (channel != null) {
            this.setString(this.find(comboBox), "text", "");
        }
        return channel;
    }

    private Subject getSelectedSubject(String listBox) {
        Subject subject = null;
        int i = this.getSelectedIndex(this.find(listBox));
        if (i > -1) {
            subject = (Subject)this.state.getAllSubjects().get(i);
        }
        return subject;
    }

    public void removeSelectedSubjectFromChannelPressed() {
        Logger.log("removeSelectedSubjectFromChannelPressed()");
        Subject subject = this.getSelectedSubject("allSubjects");
        Channel channel = this.getSelectedChannel("removeFromChannels");
        this.state.getDao().disassociateSubjectFromChannel(subject, channel);
    }

    public void outputDirPressed() {
        Logger.log("outputDirPressed()");
        FileDialog fd = new FileDialog(Frame.getFrames()[0], "Output dir...", 0);
        fd.setDirectory(this.getString(this.find("outputDir"), "text"));
        fd.show();
        this.setString(this.find("outputDir"), "text", fd.getDirectory() + fd.getFile());
    }

    public void printItemPressed() {
        Logger.log("printItemPressed()");
        System.out.println(this.getString(this.find("itemTitle"), "text"));
        System.out.println(this.getString(this.find("itemDescription"), "text"));
    }

    public void manageSubjectSelected() {
        Logger.log("manageSubjectSelected()");
        int i = this.getSelectedIndex(this.find("allSubjects"));
        if (i > -1) {
            Subject s = (Subject)this.state.getAllSubjects().get(i);
            this.state.setManageSubject(s);
            this.populateManageSubject(s);
        }
    }

    public void manageChannelSelected() {
        Logger.log("manageChannelSelected()");
        int i = this.getSelectedIndex(this.find("manageChannels"));
        if (i > -1) {
            Channel c = (Channel)this.state.getChannels().get(i);
            this.state.setManageChannel(c);
            this.populateManageChannel(c);
        }
    }

    public void populateManageChannel(Channel c) {
        this.setString(this.find("channelTitle"), "text", c.getTitle());
        this.setString(this.find("channelLink"), "text", c.getLink());
        this.setString(this.find("channelDescription"), "text", c.getDescription());
        this.setString(this.find("channelRecentItemCount"), "text", "" + c.getRecentItemCount());
        this.setString(this.find("channelStyle"), "text", c.getStyle());
        this.populateTransport(c);
    }

    public void channelTransportPressed() {
        Channel dummyChannel = new Channel();
        dummyChannel.setTransportType(this.getString(this.find("channelTransport"), "text"));
        dummyChannel.setTitle(this.getString(this.find("channelTitle"), "text"));
        dummyChannel.setTransportPropertyFile(this.getTPF(dummyChannel));
        this.populateTransport(dummyChannel);
    }

    public void populateTransport(Channel c) {
        Logger.log("populateTransport(" + c + ")");
        this.setString(this.find("channelTransport"), "text", c.getTransportType());
        this.clearList("transportDetails");
        Transport t = TransportFactory.getInstance(c.getTransportType());
        if (t != null) {
            List params = t.getParameterList();
            Properties protocolDetails = new Properties();
            try {
                protocolDetails.load(new FileInputStream(this.propertyPath + c.getTransportPropertyFile()));
            }
            catch (Exception e) {
                Logger.log(e.toString());
            }
            Iterator itr = params.iterator();
            while (itr.hasNext()) {
                String p = (String)itr.next();
                Object row = this.create("row");
                Object param = this.create("cell");
                this.setString(param, "text", p);
                this.add(row, param);
                Object value = this.create("cell");
                this.setString(value, "text", protocolDetails.getProperty(p));
                this.add(row, value);
                this.add(this.find("transportDetails"), row);
            }
        }
        this.setString(this.find("transportKey"), "text", "");
        this.setString(this.find("transportValue"), "text", "");
    }

    public void populateManageSubject(Subject s) {
        this.setString(this.find("subjectTitle"), "text", s.getTitle());
    }

    private String getTPF(Channel c) {
        return Utilities.getSafeForFilename(c.getTitle() + ".properties");
    }

    public void saveManageChannelPressed() {
        Channel unsavedChannel = this.state.getManageChannel();
        unsavedChannel.setTitle(this.getString(this.find("channelTitle"), "text"));
        unsavedChannel.setLink(this.getString(this.find("channelLink"), "text"));
        unsavedChannel.setDescription(this.getString(this.find("channelDescription"), "text"));
        unsavedChannel.setTransportType(this.getString(this.find("channelTransport"), "text"));
        unsavedChannel.setTransportPropertyFile(this.getTPF(unsavedChannel));
        unsavedChannel.setStyle(this.getString(this.find("channelStyle"), "text"));
        int i = 10;
        try {
            i = Integer.parseInt(this.getString(this.find("channelRecentItemCount"), "text"));
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        unsavedChannel.setRecentItemCount(i);
        Properties protocolDetails = new Properties();
        Object[] o = this.getItems(this.find("transportDetails"));
        for (int j = 0; j < o.length; ++j) {
            String key = this.getString(this.getItem(o[j], "cell", 0), "text");
            String value = this.getString(this.getItem(o[j], "cell", 1), "text");
            if (key == null || value == null) continue;
            protocolDetails.setProperty(key, value);
        }
        try {
            Logger.log(protocolDetails.toString());
            System.out.println("Saving protocol details to " + this.propertyPath + unsavedChannel.getTransportPropertyFile());
            protocolDetails.store(new FileOutputStream(this.propertyPath + unsavedChannel.getTransportPropertyFile()), "Blogmento '" + unsavedChannel.getTransportType() + "' details for '" + unsavedChannel.getTitle() + "'");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.state.getDao().saveChannel(unsavedChannel);
    }

    public void saveManageSubjectPressed() {
        Subject unsavedSubject = this.state.getManageSubject();
        unsavedSubject.setTitle(this.getString(this.find("subjectTitle"), "text"));
        this.state.getDao().saveSubject(unsavedSubject);
    }

    public void savePreferencesPressed() {
        Prefs unsavedPrefs = this.state.getPrefs();
        unsavedPrefs.setWorkingDirectory(this.getString(this.find("outputDir"), "text"));
        this.state.getDao().savePreferences(unsavedPrefs);
    }

    public List generateChannel() throws Exception {
        Logger.log("generateChannel()");
        ArrayList outputFiles = new ArrayList();
        if (this.state.getTemplates() != null) {
            this.makeOutputDirectoriesIfNecessary();
            Subject tempCurrentSubject = this.state.getCurrentSubject();
            this.state.setCurrentSubject(new Subject());
            Date tempCurrentDate = this.state.getCalendar().getCurrentDate();
            this.state.getCalendar().setCurrentDate(1234, 5, this.state);
            TemplateEngine engine = new TemplateEngine();
            String inputDir = this.inputPath + this.state.getCurrentStyle().getTitle() + "/";
            String outputDir = this.outputPath + this.state.getCurrentChannel().getTitle() + "/";
            this.state.setEntries(this.calculateWhichDatesHaveAnItem());
            Date d = new Date();
            this.state.getCalendar().setCurrentDate(d, this.state);
            this.state.getCalendar().setToday(d);
            Date minDate = new Date();
            Date maxDate = new Date();
            if (this.state.getItems().size() > 0) {
                minDate = ((Item)this.state.getItems().get(this.state.getItems().size() - 1)).getWhen();
                maxDate = ((Item)this.state.getItems().get(0)).getWhen();
            }
            this.state.getCalendar().setEarliestDate(minDate);
            this.generateExport(inputDir, engine, outputDir, outputFiles);
            this.copyImages(inputDir, outputDir, outputFiles);
            this.generateMainPages(inputDir, engine, outputDir, outputFiles);
            this.generateItemsBySubject(inputDir, engine, outputDir, outputFiles);
            this.generateItemsByDay(inputDir, engine, outputDir, outputFiles);
            this.generateByMonth(inputDir, engine, outputDir, outputFiles, minDate, maxDate);
            this.generateByMonthAndSubjectCombined(inputDir, engine, outputDir, outputFiles);
            this.generateByIndividualItem(inputDir, engine, outputDir, outputFiles);
            this.state.setCurrentSubject(tempCurrentSubject);
            this.state.getCalendar().setCurrentDate(tempCurrentDate, this.state);
            this.state.setItems(this.state.getDao().fetchItems(this.state.getCurrentChannel()));
        }
        return outputFiles;
    }

    private void generateByIndividualItem(String inputDir, TemplateEngine engine, String outputDir, List outputFiles) throws Exception {
        System.out.print(".");
        this.state.setDirPrefix("..");
        List fullItemList = this.state.getDao().fetchItems(this.state.getCurrentChannel());
        Iterator fullItr = fullItemList.iterator();
        while (fullItr.hasNext()) {
            Item i = (Item)fullItr.next();
            ArrayList<Item> singleList = new ArrayList<Item>();
            singleList.add(i);
            this.state.setItems(singleList);
            Iterator itr = this.state.getTemplates().iterator();
            while (itr.hasNext()) {
                Template t = (Template)itr.next();
                this.state.getCalendar().setCurrentDate(i.getWhen(), this.state);
                String outFile = "items/" + i.getId() + "-" + t.getOutputFile();
                PrintStream outT = new PrintStream(new FileOutputStream(outputDir + outFile));
                outputFiles.add(outFile);
                engine.doTemplate(outT, inputDir + t.getTitle(), this.state, t);
                outT.close();
            }
        }
        System.out.println(".");
    }

    private void generateByMonthAndSubjectCombined(String inputDir, TemplateEngine engine, String outputDir, List outputFiles) throws Exception {
        System.out.print(".");
        Subject currentSubject = this.state.getCurrentSubject();
        this.state.setDirPrefix("..");
        for (int y = this.getMinYear(); y <= this.getMaxYear(); ++y) {
            for (int m = 1; m <= 12; ++m) {
                this.state.getCalendar().setCurrentDate(y, m, this.state);
                Iterator subjectItr = this.state.getSubjects().iterator();
                while (subjectItr.hasNext()) {
                    Subject subject = (Subject)subjectItr.next();
                    this.state.setCurrentSubject(subject);
                    List allItems = this.state.getDao().fetchRecentItemsByDate(this.state.getCurrentChannel(), y, m);
                    List items = this.state.getDao().fetchRecentItemsByDateAndSubject(this.state.getCurrentChannel(), y, m, subject);
                    if (allItems.size() <= 0) continue;
                    this.state.setItems(items);
                    Iterator itr = this.state.getTemplates().iterator();
                    while (itr.hasNext()) {
                        Template t = (Template)itr.next();
                        String outFile = "";
                        outFile = m < 10 ? "months/" + Utilities.getSafeForFilename(subject.getTitle()) + "-" + y + "0" + m + "-" + t.getOutputFile() : "months/" + Utilities.getSafeForFilename(subject.getTitle()) + "-" + y + m + "-" + t.getOutputFile();
                        PrintStream outT = new PrintStream(new FileOutputStream(outputDir + outFile));
                        outputFiles.add(outFile);
                        engine.doTemplate(outT, inputDir + t.getTitle(), this.state, t);
                        outT.close();
                    }
                }
            }
        }
        this.state.setCurrentSubject(currentSubject);
    }

    private void generateByMonth(String inputDir, TemplateEngine engine, String outputDir, List outputFiles, Date minDate, Date maxDate) throws Exception {
        System.out.print(".");
        this.state.setDirPrefix("..");
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(minDate);
        this.setMinYear(c.get(1));
        c.setTime(maxDate);
        this.setMaxYear(c.get(1));
        for (int y = this.getMinYear(); y <= this.getMaxYear(); ++y) {
            for (int m = 1; m <= 12; ++m) {
                this.state.getCalendar().setCurrentDate(y, m, this.state);
                List items = this.state.getDao().fetchRecentItemsByDate(this.state.getCurrentChannel(), y, m);
                if (items.size() <= 0) continue;
                this.state.setItems(items);
                Iterator itr = this.state.getTemplates().iterator();
                while (itr.hasNext()) {
                    Template t = (Template)itr.next();
                    String outFile = "";
                    outFile = m < 10 ? "months/" + y + "0" + m + "-" + t.getOutputFile() : "months/" + y + m + "-" + t.getOutputFile();
                    PrintStream outT = new PrintStream(new FileOutputStream(outputDir + outFile));
                    outputFiles.add(outFile);
                    engine.doTemplate(outT, inputDir + t.getTitle(), this.state, t);
                    outT.close();
                }
            }
        }
    }

    private void generateItemsByDay(String inputDir, TemplateEngine engine, String outputDir, List outputFiles) throws Exception {
        System.out.print(".");
        this.state.setDirPrefix("..");
        Iterator dayItr = this.state.getEntries().iterator();
        while (dayItr.hasNext()) {
            String day = (String)dayItr.next();
            this.state.getCalendar().setCurrentDate(day, this.state);
            List items = this.state.getDao().fetchRecentItemsByDate(this.state.getCurrentChannel(), day);
            if (items.size() <= 0) continue;
            this.state.setItems(items);
            Iterator itr = this.state.getTemplates().iterator();
            while (itr.hasNext()) {
                Template t = (Template)itr.next();
                String outFile = "days/" + day + "-" + t.getOutputFile();
                PrintStream outT = new PrintStream(new FileOutputStream(outputDir + outFile));
                outputFiles.add(outFile);
                engine.doTemplate(outT, inputDir + t.getTitle(), this.state, t);
                outT.close();
            }
        }
    }

    private void generateItemsBySubject(String inputDir, TemplateEngine engine, String outputDir, List outputFiles) throws Exception {
        Subject currentSubject = this.state.getCurrentSubject();
        System.out.print(".");
        this.state.setDirPrefix("..");
        Iterator subjectItr = this.state.getSubjects().iterator();
        while (subjectItr.hasNext()) {
            Subject subject = (Subject)subjectItr.next();
            this.state.setCurrentSubject(subject);
            this.state.setItems(this.state.getDao().fetchRecentItemsBySubject(this.state.getCurrentChannel(), subject));
            Iterator itr = this.state.getTemplates().iterator();
            while (itr.hasNext()) {
                Template t = (Template)itr.next();
                String outFile = "subjects/" + Utilities.getSafeForFilename(subject.getTitle()) + "-" + t.getOutputFile();
                PrintStream outT = new PrintStream(new FileOutputStream(outputDir + outFile));
                outputFiles.add(outFile);
                engine.doTemplate(outT, inputDir + t.getTitle(), this.state, t);
                outT.close();
            }
        }
        this.state.setCurrentSubject(currentSubject);
    }

    private void generateMainPages(String inputDir, TemplateEngine engine, String outputDir, List outputFiles) throws Exception {
        System.out.print(".");
        this.state.setDirPrefix(".");
        this.state.setItems(this.state.getDao().fetchRecentItems(this.state.getCurrentChannel()));
        Iterator itr = this.state.getTemplates().iterator();
        while (itr.hasNext()) {
            Template t = (Template)itr.next();
            PrintStream outT = new PrintStream(new FileOutputStream(outputDir + t.getOutputFile()));
            outputFiles.add(t.getOutputFile());
            engine.doTemplate(outT, inputDir + t.getTitle(), this.state, t);
            outT.close();
        }
    }

    private void copyImages(String inputDir, String outputDir, List outputFiles) {
        Iterator itr = this.state.getDao().fetchImages().iterator();
        while (itr.hasNext()) {
            String file = (String)itr.next();
            outputFiles.add(file);
            Utilities.copyRawFile(System.getProperty("styles") + File.separator + inputDir + file, outputDir + file);
        }
    }

    private void generateExport(String inputDir, TemplateEngine engine, String outputDir, List outputFiles) throws Exception {
        System.out.print(".");
        this.state.setDirPrefix("..");
        Iterator itr = this.state.getTemplates().iterator();
        while (itr.hasNext()) {
            Template t = (Template)itr.next();
            PrintStream outT = new PrintStream(new FileOutputStream(outputDir + "export/" + t.getOutputFile()));
            outputFiles.add("export/" + t.getOutputFile());
            engine.doTemplate(outT, inputDir + t.getTitle(), this.state, t);
            outT.close();
        }
    }

    private Set calculateWhichDatesHaveAnItem() {
        HashSet<String> s = new HashSet<String>();
        Iterator allItr = this.state.getItems().iterator();
        while (allItr.hasNext()) {
            Item i = (Item)allItr.next();
            s.add(i.getWhenAs("yyyyMMdd"));
        }
        return s;
    }

    private void makeOutputDirectoriesIfNecessary() {
        try {
            File d = new File(this.outputPath);
            if (!d.exists()) {
                d.mkdirs();
            }
            String channelName = this.state.getCurrentChannel().getTitle();
            d = new File(this.outputPath + channelName + "/export");
            if (!d.exists()) {
                d.mkdirs();
            }
            if (!(d = new File(this.outputPath + channelName + "/subjects")).exists()) {
                d.mkdirs();
            }
            if (!(d = new File(this.outputPath + channelName + "/days")).exists()) {
                d.mkdirs();
            }
            if (!(d = new File(this.outputPath + channelName + "/months")).exists()) {
                d.mkdirs();
            }
            if (!(d = new File(this.outputPath + channelName + "/items")).exists()) {
                d.mkdirs();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void uploadChannel(List outputFiles) {
        Logger.log("uploadChannel()");
        if (this.state.getCurrentChannel().getId() > -1) {
            String outputDir = this.outputPath + this.state.getCurrentChannel().getTitle() + "/";
            Properties protocolDetails = new Properties();
            boolean uploadable = false;
            try {
                protocolDetails.load(new FileInputStream(this.propertyPath + this.state.getCurrentChannel().getTransportPropertyFile()));
                uploadable = true;
            }
            catch (Exception e) {
                System.out.println("could not find upload details in file " + this.state.getCurrentChannel().getTransportPropertyFile());
            }
            if (uploadable) {
                Transport t = TransportFactory.getInstance(this.state.getCurrentChannel().getTransportType());
                t.upload(outputDir, outputFiles, protocolDetails);
            } else {
                System.out.println("not uploaded.");
            }
        }
    }

    public void generatePressed() {
        this.generate();
    }

    public List generate() {
        Logger.log("generate()");
        List outputFiles = null;
        this.saveItemPressed();
        try {
            outputFiles = this.generateChannel();
            this.popup("generated " + this.state.getCurrentChannel().getTitle() + "...");
            System.out.println("local url is   " + this.outputPath + this.state.getCurrentChannel().getTitle());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return outputFiles;
    }

    public void publishPressed() {
        Logger.log("publishPressed()");
        try {
            List outputFiles = this.generate();
            this.uploadChannel(outputFiles);
            this.popup("published " + this.state.getCurrentChannel().getTitle() + ".");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void wizardPressed() {
        Wizard w = new Wizard(this.state, this);
        PopupLauncher wl = new PopupLauncher("Blogmento Wizard", w, 640, 480);
        w.setWindowListener(wl);
    }

    public void dotdotdotPressed() {
        Logger.log(" - - - - - - - - - - - - - - - - - - -");
        Logger.log("currentChannel " + this.state.getCurrentChannel());
        Logger.log("currentSubject " + this.state.getCurrentSubject());
        Logger.log("currentItem " + this.state.getCurrentItem());
        Logger.log(" - - - - - - - - - - - - - - - - - - -");
    }

    public void exitPressed() {
        Logger.log("exitPressed()");
        this.state.getDao().closeConnection();
        System.exit(0);
    }

    public void repopulateStyles() {
        Logger.log("repopulateStyles()");
        this.state.setStyles(this.state.getDao().fetchStyles());
        this.clearList("channelStyle");
        this.populateStyles();
    }

    public void repopulatePrefs() {
        Logger.log("repopulatePrefs()");
        Prefs p = this.state.getDao().fetchPrefs();
        if (p != null) {
            this.state.setPrefs(p);
            this.outputPath = this.state.getPrefs().getWorkingDirectory() + "/blogmento/channels/";
            this.propertyPath = this.state.getPrefs().getWorkingDirectory() + "/blogmento/";
        }
        this.populatePrefs();
    }

    private void populatePrefs() {
        this.setString(this.find("outputDir"), "text", this.state.getPrefs().getWorkingDirectory());
    }

    public void repopulateChannels() {
        Logger.log("repopulateChannels()");
        this.state.setChannels(this.state.getDao().fetchChannels());
        this.clearList("channels");
        this.populateChannels();
        this.selectCurrentChannel();
        this.clearList("manageChannels");
        this.populateManageChannels();
        this.clearList("addToChannels");
        this.populateAddToChannels();
        this.clearList("removeFromChannels");
        this.populateRemoveFromChannels();
        this.repopulateSubjects();
    }

    public void repopulateSubjects() {
        Logger.log("repopulateSubjects()");
        this.state.setSubjects(this.state.getDao().fetchSubjects(this.state.getCurrentChannel()));
        this.clearList("subjects");
        this.populateSubjects();
        this.selectFirstSubject();
        this.repopulateItems();
    }

    public void repopulateAllSubjects() {
        Logger.log("repopulateAllSubjects()");
        this.state.setAllSubjects(this.state.getDao().fetchAllSubjects());
        this.clearList("allSubjects");
        this.populateAllSubjects();
        if (this.state.getCurrentChannel().getId() > -1) {
            this.repopulateSubjects();
        }
    }

    public void repopulateItems() {
        Logger.log("repopulateItems()");
        if (this.state.isGuiMode()) {
            this.state.setItems(this.state.getDao().fetchItems(this.state.getCurrentChannel()));
            this.clearList("items");
            this.populateItems();
            this.selectCurrentItem();
            this.repopulateItem();
        }
    }

    public void repopulateItem() {
        this.populateItem(this.state.getCurrentItem());
    }

    public void popup(String message) {
        Logger.log("popup(" + message + ")");
        if (this.state.isGuiMode()) {
            this.setString(this.find("status"), "text", message);
        }
        System.out.println(message);
    }

    public void populateItem(Item item) {
        Logger.log("populateItem(" + item + ")");
        this.state.setCurrentItem(item);
        this.setString(this.find("itemTitle"), "text", item.getTitle());
        this.setString(this.find("itemDescription"), "text", item.getDescription());
        this.setString(this.find("itemDate"), "text", this.df.format(item.getWhen()));
    }

    public void populateItems() {
        Logger.log("populateItems()");
        Iterator itr = this.state.getItems().iterator();
        while (itr.hasNext()) {
            Item i = (Item)itr.next();
            Object row = this.create("row");
            Object date = this.create("cell");
            this.setString(date, "text", this.df.format(i.getWhen()));
            this.add(row, date);
            Object subject = this.create("cell");
            this.setString(subject, "text", i.getSubject());
            this.add(row, subject);
            Object title = this.create("cell");
            this.setString(title, "text", i.getTitle());
            this.add(row, title);
            this.add(this.find("items"), row);
        }
    }

    public void populateChannels() {
        Logger.log("populateChannels()");
        Iterator itr = this.state.getChannels().iterator();
        while (itr.hasNext()) {
            Channel c = (Channel)itr.next();
            Object row = this.create("row");
            Object channel = this.create("cell");
            this.setString(channel, "text", c.getTitle());
            this.add(row, channel);
            this.add(this.find("channels"), row);
        }
        if (this.state.getChannels().size() > 0) {
            this.selectCurrentChannel();
        }
    }

    public void populateStyles() {
        Logger.log("populateStyles()");
        Iterator itr = this.state.getStyles().iterator();
        while (itr.hasNext()) {
            Style s = (Style)itr.next();
            Object style = this.create("choice");
            this.setString(style, "text", s.getTitle());
            this.add(this.find("channelStyle"), style);
        }
    }

    public void populateAddToChannels() {
        Logger.log("populateAddToChannels()");
        Iterator itr = this.state.getChannels().iterator();
        while (itr.hasNext()) {
            Channel c = (Channel)itr.next();
            Object channel = this.create("choice");
            this.setString(channel, "text", c.getTitle());
            this.add(this.find("addToChannels"), channel);
        }
    }

    public void populateRemoveFromChannels() {
        Logger.log("populateRemoveFromChannels()");
        Iterator itr = this.state.getChannels().iterator();
        while (itr.hasNext()) {
            Channel c = (Channel)itr.next();
            Object channel = this.create("choice");
            this.setString(channel, "text", c.getTitle());
            this.add(this.find("removeFromChannels"), channel);
        }
    }

    public void populateManageChannels() {
        Logger.log("populateManageChannels()");
        Iterator itr = this.state.getChannels().iterator();
        while (itr.hasNext()) {
            Channel c = (Channel)itr.next();
            Object row2 = this.create("row");
            Object channel2 = this.create("cell");
            this.setString(channel2, "text", c.getTitle());
            this.add(row2, channel2);
            this.add(this.find("manageChannels"), row2);
        }
    }

    public void populateSubjects() {
        Logger.log("populateSubjects()");
        Iterator itr = this.state.getSubjects().iterator();
        while (itr.hasNext()) {
            Subject s = (Subject)itr.next();
            Object row = this.create("row");
            Object subject = this.create("cell");
            this.setString(subject, "text", s.getTitle());
            this.add(row, subject);
            this.add(this.find("subjects"), row);
        }
        if (this.state.getSubjects().size() > 0) {
            this.setSelectedIndex(this.find("subjects"), 0);
        }
    }

    public void populateAllSubjects() {
        Logger.log("populateAllSubjects()");
        Iterator itr = this.state.getAllSubjects().iterator();
        while (itr.hasNext()) {
            Subject s = (Subject)itr.next();
            Object row = this.create("row");
            Object subject = this.create("cell");
            this.setString(subject, "text", s.getTitle());
            this.add(row, subject);
            this.add(this.find("allSubjects"), row);
        }
        if (this.state.getAllSubjects().size() > 0) {
            this.setSelectedIndex(this.find("allSubjects"), 0);
        }
    }

    public void selectChannel(int i) {
        Logger.log("selectChannel(" + i + ")");
        this.setSelectedIndex(this.find("channels"), i);
    }

    public void selectSubject(Item i) {
        Logger.log("selectSubject(" + i + ")");
        int index = this.findSubject(i.getSubject());
        if (index > -1) {
            this.setSelectedIndex(this.find("subjects"), index);
            this.state.setCurrentSubject((Subject)this.state.getSubjects().get(index));
        }
    }

    public int findSubject(String subjectText) {
        int index = -1;
        if (subjectText != null) {
            Iterator itr = this.state.getSubjects().iterator();
            while (itr.hasNext()) {
                Subject s = (Subject)itr.next();
                ++index;
                if (!subjectText.equals(s.getTitle())) continue;
                break;
            }
        }
        return index;
    }

    public void selectFirstChannel() {
        Logger.log("selectFirstChannel()");
        if (this.state.getChannels().size() > 0) {
            this.setSelectedIndex(this.find("channels"), 0);
            this.channelSelected();
        }
    }

    public void selectFirstManageChannel() {
        Logger.log("selectFirstManageChannel()");
        if (this.state.getChannels().size() > 0) {
            this.setSelectedIndex(this.find("manageChannels"), 0);
            this.manageChannelSelected();
        }
    }

    public void selectFirstSubject() {
        Logger.log("selectFirstSubject()");
        if (this.state.getSubjects().size() > 0) {
            this.setSelectedIndex(this.find("subjects"), 0);
            this.state.setCurrentSubject((Subject)this.state.getSubjects().get(0));
        }
    }

    public void selectFirstManageSubject() {
        Logger.log("selectFirstManageSubject()");
        if (this.state.getAllSubjects().size() > 0) {
            this.setSelectedIndex(this.find("allSubjects"), 0);
            this.state.setManageSubject((Subject)this.state.getAllSubjects().get(0));
            this.manageSubjectSelected();
        }
    }

    public void selectItem(int i) {
        Logger.log("selectItem(" + i + ")");
        this.setSelectedIndex(this.find("items"), i);
    }

    public void selectCurrentChannel() {
        Logger.log("selectCurrentChannel()");
        int i = -1;
        Iterator itr = this.state.getChannels().iterator();
        while (itr.hasNext()) {
            ++i;
            if (!this.state.getCurrentChannel().equals(itr.next())) continue;
            this.selectChannel(i);
        }
        this.state.setTemplates(this.state.getDao().fetchTemplates());
        this.state.setCurrentStyle(this.state.getDao().fetchStyle(this.state.getCurrentChannel()));
    }

    public void selectCurrentSubject() {
        Logger.log("selectCurrentSubject()");
        this.selectSubject(this.state.getCurrentItem());
    }

    public void selectCurrentItem() {
        Logger.log("selectCurrentItem()");
        int i = -1;
        Iterator itr = this.state.getItems().iterator();
        while (itr.hasNext()) {
            ++i;
            if (!this.state.getCurrentItem().equals(itr.next())) continue;
            this.selectItem(i);
        }
    }

    public void clearList(String objectName) {
        Logger.log("clearList(" + objectName + ")");
        Object list = this.find(objectName);
        for (int ii = this.getCount(list) - 1; ii >= 0; --ii) {
            Object item = this.getItem(list, ii);
            this.remove(item);
        }
    }
}

