/*
 * Decompiled with CFR 0.152.
 */
package com.javanicus.blogmento;

import com.javanicus.blogmento.BlogState;
import com.javanicus.blogmento.CalendarEntry;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

public class Cal {
    private List calendarItems;
    private List days;
    private Date currentDate;
    private Date prev;
    private Date next;
    private Date today;
    private Date earliestDate;

    public void setCalendarItems(List l) {
        this.calendarItems = l;
    }

    public Date getCurrentDate() {
        return this.currentDate;
    }

    public Date getToday() {
        return this.today;
    }

    public void setToday(Date d) {
        this.today = d;
    }

    public void setEarliestDate(Date d) {
        this.earliestDate = d;
    }

    public void setCurrentDate(int year, int month, BlogState state) {
        GregorianCalendar c = new GregorianCalendar(year, month - 1, 1);
        Date d = c.getTime();
        this.setCurrentDate(d, state);
    }

    public void setCurrentDate(String day, BlogState state) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        try {
            this.setCurrentDate(sdf.parse(day), state);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setCurrentDate(Date d, BlogState state) {
        if (d != null) {
            this.currentDate = d;
            GregorianCalendar c = new GregorianCalendar();
            c.setTime(d);
            this.days = this.populateDays(c, c.get(1), c.get(2), state);
            ((Calendar)c).add(2, -1);
            this.prev = c.getTime();
            c.setTime(d);
            ((Calendar)c).add(2, 1);
            this.next = c.getTime();
        }
    }

    public String getPreviousDateAs(String format) {
        if (this.earliestDate != null) {
            GregorianCalendar earliestCal = new GregorianCalendar();
            GregorianCalendar prevCal = new GregorianCalendar();
            earliestCal.setTime(this.earliestDate);
            prevCal.setTime(this.prev);
            if (prevCal.before(earliestCal)) {
                return this.getEarliestDateAs(format);
            }
        }
        String dateString = null;
        SimpleDateFormat dateFormat = new SimpleDateFormat();
        dateFormat.applyPattern(format);
        dateFormat.setLenient(false);
        dateString = dateFormat.format(this.prev);
        return dateString;
    }

    public String getCurrentDateAs(String format) {
        String dateString = null;
        SimpleDateFormat dateFormat = new SimpleDateFormat();
        dateFormat.applyPattern(format);
        dateFormat.setLenient(false);
        dateString = dateFormat.format(this.getCurrentDate());
        return dateString;
    }

    public String getTodayAs(String format) {
        String dateString = null;
        SimpleDateFormat dateFormat = new SimpleDateFormat();
        dateFormat.applyPattern(format);
        dateFormat.setLenient(false);
        dateString = dateFormat.format(this.today);
        return dateString;
    }

    public String getEarliestDateAs(String format) {
        String dateString = null;
        SimpleDateFormat dateFormat = new SimpleDateFormat();
        dateFormat.applyPattern(format);
        dateFormat.setLenient(false);
        dateString = dateFormat.format(this.earliestDate);
        return dateString;
    }

    public String getNextDateAs(String format) {
        GregorianCalendar todayCal = new GregorianCalendar();
        GregorianCalendar nextCal = new GregorianCalendar();
        todayCal.setTime(this.today);
        nextCal.setTime(this.next);
        if (nextCal.after(todayCal)) {
            return this.getTodayAs(format);
        }
        String dateString = null;
        SimpleDateFormat dateFormat = new SimpleDateFormat();
        dateFormat.applyPattern(format);
        dateFormat.setLenient(false);
        dateString = dateFormat.format(this.next);
        return dateString;
    }

    public List getDays() {
        return this.days;
    }

    private List populateDays(Calendar c, int year, int month, BlogState state) {
        int i;
        ArrayList<CalendarEntry> days = new ArrayList<CalendarEntry>();
        GregorianCalendar c2 = new GregorianCalendar(year, month, 1);
        int daysInMonth = c.getActualMaximum(5);
        int offset = 0;
        if (c2.get(7) == 1) {
            offset = 0;
        } else if (c2.get(7) == 2) {
            offset = 1;
        } else if (c2.get(7) == 3) {
            offset = 2;
        } else if (c2.get(7) == 4) {
            offset = 3;
        } else if (c2.get(7) == 5) {
            offset = 4;
        } else if (c2.get(7) == 6) {
            offset = 5;
        } else if (c2.get(7) == 7) {
            offset = 6;
        }
        for (i = 0; i < offset; ++i) {
            days.add(new CalendarEntry("", false, false));
        }
        for (i = 1; i <= daysInMonth; ++i) {
            int realMonth = month + 1;
            String yearMonthDay = realMonth < 10 ? (i < 10 ? year + "0" + realMonth + "0" + i : year + "0" + realMonth + i) : (i < 10 ? year + realMonth + "0" + i : year + realMonth + "" + i);
            boolean hasEntry = false;
            if (state.getEntries() != null) {
                hasEntry = state.getEntries().contains(yearMonthDay);
            }
            days.add(new CalendarEntry("" + i, false, hasEntry));
        }
        return days;
    }
}

