/*
 * Decompiled with CFR 0.152.
 */
package com.javanicus.blogmento;

import com.javanicus.blogmento.Blogmento;
import com.javanicus.blogmento.Channel;
import com.javanicus.blogmento.Item;
import com.javanicus.blogmento.Logger;
import com.javanicus.blogmento.Prefs;
import com.javanicus.blogmento.Style;
import com.javanicus.blogmento.Subject;
import com.javanicus.blogmento.Template;
import com.javanicus.blogmento.Utilities;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

public class DataAccessObject {
    private Connection connection;
    private Blogmento view;

    public DataAccessObject(Blogmento b) {
        this.view = b;
    }

    public Connection getConnection() throws ClassNotFoundException, SQLException {
        Logger.log("DataAccessObject.getConnection()");
        Class.forName("org.hsqldb.jdbcDriver");
        String dburl = System.getProperty("dburl");
        try {
            System.out.println("dburl:" + dburl.substring(12));
            String file = dburl.substring(12) + ".script";
            String currDate = Utilities.getCurrDate();
            Logger.log("trying to backup database at : " + file);
            Utilities.copyFile(file, file + "." + currDate);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.connection = DriverManager.getConnection(dburl, "sa", "");
        return this.connection;
    }

    public void saveItem(Subject currentSubject, Item item) {
        Logger.log("DataAccessObject.saveItem(" + item + ")");
        if (item == null || "".equals((item.getTitle() + item.getDescription()).trim())) {
            Logger.log("nothing to save");
            return;
        }
        try {
            String when = this.userDateToSqlDate(item.getWhen());
            String lastUpdated = this.userDateToSqlDate(item.getLastUpdated());
            Statement s = this.connection.createStatement();
            String sql = "";
            if (currentSubject.getId() > -1) {
                if (item.getId() < 0) {
                    item.setId(this.getNextId("ITEM"));
                    sql = "insert into item values (" + item.getId() + ",'" + Utilities.getSafeForSQL(item.getTitle()) + "','" + when + "','" + Utilities.getSafeForSQL(item.getDescription()) + "','" + lastUpdated + "'," + currentSubject.getId() + ")";
                } else {
                    sql = "update item set title='" + Utilities.getSafeForSQL(item.getTitle()) + "', when='" + when + "', description='" + Utilities.getSafeForSQL(item.getDescription()) + "', last_updated='" + lastUpdated + "', fk_subject_id=" + currentSubject.getId() + " where item_id = " + item.getId();
                }
            } else {
                Logger.log("DataAccessObject.SUBJECT ID IS -1 need to save");
            }
            Logger.log(sql);
            s.executeUpdate(sql);
            s.close();
            this.view.popup("Saved " + item.getTitle());
            this.view.repopulateItems();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void saveChannel(Channel channel) {
        Logger.log("DataAccessObject.saveChannel(" + channel + ")");
        if (channel == null || "".equals((channel.getTitle() + channel.getDescription()).trim())) {
            Logger.log("nothing to save");
            return;
        }
        try {
            Statement s = this.connection.createStatement();
            String sql = "";
            if (channel.getId() < 0) {
                channel.setId(this.getNextId("CHANNEL"));
                sql = "insert into channel values (" + channel.getId() + ",'" + Utilities.getSafeForSQL(channel.getTitle()) + "','" + Utilities.getSafeForSQL(channel.getLink()) + "','" + Utilities.getSafeForSQL(channel.getDescription()) + "','" + Utilities.getSafeForSQL(channel.getStyle()) + "','" + Utilities.getSafeForSQL(channel.getTransportType()) + "','" + Utilities.getSafeForSQL(channel.getTransportPropertyFile()) + "'," + channel.getRecentItemCount() + ")";
            } else {
                sql = "update channel set title='" + Utilities.getSafeForSQL(channel.getTitle()) + "', link='" + Utilities.getSafeForSQL(channel.getLink()) + "', description='" + Utilities.getSafeForSQL(channel.getDescription()) + "', style_dir='" + Utilities.getSafeForSQL(channel.getStyle()) + "', transport_type  ='" + Utilities.getSafeForSQL(channel.getTransportType()) + "',transport_property_file ='" + Utilities.getSafeForSQL(channel.getTransportPropertyFile()) + "',recent_item_count =" + channel.getRecentItemCount() + " where channel_id = " + channel.getId();
            }
            Logger.log(sql);
            s.executeUpdate(sql);
            s.close();
            this.view.popup("Saved channel " + channel.getTitle());
            this.view.repopulateChannels();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void saveSubject(Subject subject) {
        Logger.log("DataAccessObject.saveSubject(" + subject + ")");
        if (subject == null || "".equals(subject.getTitle().trim())) {
            Logger.log("nothing to save");
            return;
        }
        try {
            Statement s = this.connection.createStatement();
            String sql = "";
            if (subject.getId() < 0) {
                subject.setId(this.getNextId("SUBJECT"));
                sql = "insert into subject values (" + subject.getId() + ",'" + Utilities.getSafeForSQL(subject.getTitle()) + "')";
            } else {
                sql = "update subject set title='" + Utilities.getSafeForSQL(subject.getTitle()) + "' where subject_id = " + subject.getId();
            }
            Logger.log(sql);
            s.executeUpdate(sql);
            s.close();
            this.view.popup("Saved subject " + subject.getTitle());
            this.view.repopulateAllSubjects();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void associateSubjectWithChannel(Subject subject, Channel channel) {
        Logger.log("DataAccessObject.associateSubjectWithChannel(" + subject + "," + channel + ")");
        if (subject == null || subject.getId() < 0 || channel == null || channel.getId() < 0) {
            Logger.log("Cannot associate as missing parameter(s)");
            return;
        }
        try {
            Statement s = this.connection.createStatement();
            String sql = "delete from subjectchannel where  fk_subject_id=" + subject.getId() + " and " + " fk_channel_id=" + channel.getId();
            Logger.log(sql);
            s.executeUpdate(sql);
            sql = "insert into subjectchannel values (" + subject.getId() + "," + channel.getId() + ")";
            Logger.log(sql);
            s.executeUpdate(sql);
            s.close();
            this.view.popup("Saved subject/channel " + subject.getTitle() + "/" + channel.getTitle());
            this.view.repopulateSubjects();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public String userDateToSqlDate(Date when) {
        Logger.log("DataAccessObject.userDateToSqlDate(" + when + ")");
        String sqlWhen = null;
        SimpleDateFormat sqlDf = new SimpleDateFormat();
        sqlDf.applyPattern("yyyy-MM-dd kk:mm:ss.S");
        sqlDf.setLenient(false);
        sqlWhen = sqlDf.format(when);
        return sqlWhen;
    }

    public List fetchStyles() {
        Logger.log("DataAccessObject.fetchStyles()");
        ArrayList<Style> styles = new ArrayList<Style>();
        try {
            String stylePath = System.getProperty("styles");
            File dir = new File(stylePath);
            if (dir.isDirectory()) {
                String[] dirList = dir.list();
                for (int i = 0; i < dirList.length; ++i) {
                    File dirItem = new File(stylePath + File.separator + dirList[i]);
                    if (!dirItem.isDirectory()) continue;
                    styles.add(new Style(i, dirList[i], dirList[i]));
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return styles;
    }

    public List fetchChannels() {
        Logger.log("DataAccessObject.fetchChannels()");
        ArrayList<Channel> channels = new ArrayList<Channel>();
        try {
            Statement s = this.connection.createStatement();
            ResultSet rs = s.executeQuery("select channel_id,title,link,description,transport_type,transport_property_file,recent_item_count,style_dir  from channel order by title");
            while (rs.next()) {
                channels.add(new Channel(rs.getInt(1), rs.getString(2), rs.getString(3), rs.getString(4), rs.getString(5), rs.getString(6), rs.getInt(7), rs.getString(8)));
            }
            Logger.log("DataAccessObject.c:" + channels);
            rs.close();
            s.close();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return channels;
    }

    private boolean isImage(String fileName) {
        boolean rv = false;
        if (fileName != null && fileName.length() > 3) {
            if ("jpg".equals(fileName.substring(fileName.length() - 3))) {
                rv = true;
            } else if ("gif".equals(fileName.substring(fileName.length() - 3))) {
                rv = true;
            }
        }
        return rv;
    }

    public List fetchTemplates() {
        Logger.log("DataAccessObject.fetchTemplates()");
        ArrayList<Template> templates = new ArrayList<Template>();
        String stylePath = System.getProperty("styles");
        String specificStylePath = stylePath + File.separator + this.view.getState().getCurrentChannel().getStyle();
        Logger.log("specificStylePath:" + specificStylePath);
        File dir = new File(specificStylePath);
        if (dir.isDirectory()) {
            String[] dirList = dir.list();
            for (int i = 0; i < dirList.length; ++i) {
                if (this.isImage(dirList[i])) continue;
                templates.add(new Template(i, dirList[i], dirList[i], dirList[i]));
            }
        }
        Logger.log("file templates:" + templates);
        return templates;
    }

    public List fetchImages() {
        Logger.log("DataAccessObject.fetchImages()");
        ArrayList<String> images = new ArrayList<String>();
        String stylePath = System.getProperty("styles");
        String specificStylePath = stylePath + File.separator + this.view.getState().getCurrentChannel().getStyle();
        Logger.log("specificStylePath:" + specificStylePath);
        File dir = new File(specificStylePath);
        if (dir.isDirectory()) {
            String[] dirList = dir.list();
            for (int i = 0; i < dirList.length; ++i) {
                if (!this.isImage(dirList[i])) continue;
                images.add(dirList[i]);
            }
        }
        Logger.log("file images:" + images);
        return images;
    }

    public List fetchAllSubjects() {
        Logger.log("DataAccessObject.fetchAllSubjects()");
        ArrayList<Subject> subjects = new ArrayList<Subject>();
        try {
            Statement s = this.connection.createStatement();
            ResultSet rs = s.executeQuery("select s.subject_id,s.title  from subject s  order by 2");
            while (rs.next()) {
                subjects.add(new Subject(rs.getInt(1), rs.getString(2)));
            }
            Logger.log("DataAccessObject.s:" + subjects);
            rs.close();
            s.close();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return subjects;
    }

    public List fetchSubjects(Channel currentChannel) {
        Logger.log("DataAccessObject.fetchSubjects(" + currentChannel + ")");
        String whereClause = "";
        if (currentChannel != null) {
            whereClause = " c.channel_id = " + currentChannel.getId() + " and ";
        }
        ArrayList<Subject> subjects = new ArrayList<Subject>();
        try {
            Statement s = this.connection.createStatement();
            ResultSet rs = s.executeQuery("select s.subject_id,s.title  from channel c, subjectchannel sc, subject s  where " + whereClause + " sc.fk_channel_id = c.channel_id and " + " sc.fk_subject_id = s.subject_id " + " order by 2");
            while (rs.next()) {
                subjects.add(new Subject(rs.getInt(1), rs.getString(2)));
            }
            Logger.log("DataAccessObject.s:" + subjects);
            rs.close();
            s.close();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return subjects;
    }

    public Style fetchStyle(Channel currentChannel) {
        Logger.log("DataAccessObject.fetchStyle(" + currentChannel + ")");
        Style style = new Style(1, currentChannel.getStyle(), currentChannel.getStyle());
        return style;
    }

    public List fetchItems(Channel currentChannel) {
        Logger.log("DataAccessObject.fetchItems(" + currentChannel + ")");
        ArrayList<Item> items = new ArrayList<Item>();
        try {
            Statement s = this.connection.createStatement();
            ResultSet rs = s.executeQuery("select i.item_id,i.title,i.when,i.description,i.last_updated,s.title from channel c, subjectchannel sc, item i, subject s where c.channel_id = " + currentChannel.getId() + " and s.subject_id = i.fk_subject_id " + " and sc.fk_channel_id = c.channel_id " + " and sc.fk_subject_id = s.subject_id order by 3 desc");
            while (rs.next()) {
                items.add(new Item(rs.getInt(1), rs.getString(2), rs.getTimestamp(3), rs.getString(4), rs.getTimestamp(5), rs.getString(6)));
            }
            Logger.log("DataAccessObject.i:" + items);
            rs.close();
            s.close();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return items;
    }

    public List fetchRecentItems(Channel currentChannel) {
        Logger.log("DataAccessObject.fetchRecentItems(" + currentChannel + ")");
        ArrayList<Item> items = new ArrayList<Item>();
        try {
            Statement s = this.connection.createStatement();
            ResultSet rs = s.executeQuery("select i.item_id,i.title,i.when,i.description,i.last_updated,s.title from channel c, subjectchannel sc, item i, subject s where c.channel_id = " + currentChannel.getId() + " and s.subject_id = i.fk_subject_id " + " and sc.fk_channel_id = c.channel_id " + " and sc.fk_subject_id = s.subject_id order by 3 desc");
            for (int i = 0; rs.next() && i < currentChannel.getRecentItemCount(); ++i) {
                items.add(new Item(rs.getInt(1), rs.getString(2), rs.getTimestamp(3), rs.getString(4), rs.getTimestamp(5), rs.getString(6)));
            }
            Logger.log("DataAccessObject.i:" + items);
            rs.close();
            s.close();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return items;
    }

    public List fetchRecentItemsBySubject(Channel currentChannel, Subject subject) {
        Logger.log("DataAccessObject.fetchRecentItemsBySubject(" + currentChannel + "," + subject + ")");
        ArrayList<Item> items = new ArrayList<Item>();
        try {
            Statement s = this.connection.createStatement();
            ResultSet rs = s.executeQuery("select i.item_id,i.title,i.when,i.description,i.last_updated,s.title from item i, subject s where i.fk_subject_id = s.subject_id and s.subject_id = " + subject.getId() + " order by 3 desc");
            for (int i = 0; rs.next() && i < currentChannel.getRecentItemCount(); ++i) {
                items.add(new Item(rs.getInt(1), rs.getString(2), rs.getTimestamp(3), rs.getString(4), rs.getTimestamp(5), rs.getString(6)));
            }
            Logger.log("DataAccessObject.i:" + items);
            rs.close();
            s.close();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return items;
    }

    public List fetchRecentItemsByDate(Channel currentChannel, int year, int month) {
        Logger.log("DataAccessObject.fetchRecentItemsByDate(" + currentChannel + "," + year + "," + month + ")");
        ArrayList<Item> items = new ArrayList<Item>();
        int i = 0;
        try {
            Statement s = this.connection.createStatement();
            ResultSet rs = s.executeQuery("select i.item_id,i.title,i.when,i.description,i.last_updated,s.title from channel c, subjectchannel sc, item i, subject s where c.channel_id = " + currentChannel.getId() + " and s.subject_id = i.fk_subject_id " + " and sc.fk_channel_id = c.channel_id " + " and year(i.when) = " + year + " and month(i.when) = " + month + " and sc.fk_subject_id = s.subject_id order by 3 desc");
            while (rs.next()) {
                items.add(new Item(rs.getInt(1), rs.getString(2), rs.getTimestamp(3), rs.getString(4), rs.getTimestamp(5), rs.getString(6)));
                ++i;
            }
            Logger.log("DataAccessObject.i:" + items);
            rs.close();
            s.close();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return items;
    }

    public List fetchRecentItemsByDateAndSubject(Channel currentChannel, int year, int month, Subject subject) {
        Logger.log("DataAccessObject.fetchRecentItemsByDate(" + currentChannel + "," + year + "," + month + "," + subject + ")");
        ArrayList<Item> items = new ArrayList<Item>();
        int i = 0;
        try {
            Statement s = this.connection.createStatement();
            ResultSet rs = s.executeQuery("select i.item_id,i.title,i.when,i.description,i.last_updated,s.title from item i, subject s where s.subject_id = " + subject.getId() + " and s.subject_id = i.fk_subject_id " + " and year(i.when) = " + year + " and month(i.when) = " + month + " order by 3 desc");
            while (rs.next()) {
                items.add(new Item(rs.getInt(1), rs.getString(2), rs.getTimestamp(3), rs.getString(4), rs.getTimestamp(5), rs.getString(6)));
                ++i;
            }
            Logger.log("DataAccessObject.i:" + items);
            rs.close();
            s.close();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return items;
    }

    public List fetchRecentItemsByDate(Channel currentChannel, String dayAsString) {
        Logger.log("DataAccessObject.fetchRecentItemsByDate(" + currentChannel + "," + dayAsString + ")");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        Date d = new Date();
        try {
            d = sdf.parse(dayAsString);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(d);
        int year = c.get(1);
        int month = c.get(2) + 1;
        int day = c.get(5);
        ArrayList<Item> items = new ArrayList<Item>();
        int i = 0;
        try {
            Statement s = this.connection.createStatement();
            ResultSet rs = s.executeQuery("select i.item_id,i.title,i.when,i.description,i.last_updated,s.title from channel c, subjectchannel sc, item i, subject s where c.channel_id = " + currentChannel.getId() + " and s.subject_id = i.fk_subject_id " + " and sc.fk_channel_id = c.channel_id " + " and year(i.when) = " + year + " and month(i.when) = " + month + " and dayofmonth(i.when) = " + day + " and sc.fk_subject_id = s.subject_id order by 3 desc");
            while (rs.next()) {
                items.add(new Item(rs.getInt(1), rs.getString(2), rs.getTimestamp(3), rs.getString(4), rs.getTimestamp(5), rs.getString(6)));
                ++i;
            }
            Logger.log("DataAccessObject.i:" + items);
            rs.close();
            s.close();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return items;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextId(String table) throws SQLException {
        Logger.log("DataAccessObject.getNextId(" + table + ")");
        int rv = -1;
        Statement s = null;
        ResultSet rs = null;
        try {
            s = this.connection.createStatement();
            rs = s.executeQuery("select last_index from idseq where table_name = '" + table + "'");
            while (rs.next()) {
                rv = rs.getInt(1);
            }
        }
        finally {
            rs.close();
        }
        ++rv;
        try {
            if (rv > 0) {
                s.executeUpdate("update idseq set last_index=" + rv + " where table_name = '" + table + "'");
            }
        }
        finally {
            s.close();
        }
        return rv;
    }

    public void closeConnection() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public void savePreferences(Prefs prefs) {
        Logger.log("DataAccessObject.savePreferences(" + prefs + ")");
        if (prefs == null) {
            Logger.log("nothing to save");
            return;
        }
        try {
            Statement s = this.connection.createStatement();
            String sql = "delete from preferences";
            Logger.log(sql);
            s.executeUpdate(sql);
            sql = "insert into preferences values ('" + Utilities.getSafeForSQL(prefs.getWorkingDirectory()) + "')";
            Logger.log(sql);
            s.executeUpdate(sql);
            s.close();
            this.view.popup("Saved preferences");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public Prefs fetchPrefs() {
        Logger.log("DataAccessObject.fetchPrefs()");
        Prefs prefs = null;
        try {
            Statement s = this.connection.createStatement();
            ResultSet rs = s.executeQuery("select working_directory from preferences");
            while (rs.next()) {
                prefs = new Prefs(rs.getString(1));
            }
            Logger.log("DataAccessObject.prefs:" + prefs);
            rs.close();
            s.close();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return prefs;
    }

    public void disassociateSubjectFromChannel(Subject subject, Channel channel) {
        Logger.log("DataAccessObject.disassociateSubjectFromChannel(" + subject + "," + channel + ")");
        if (subject == null || subject.getId() < 0 || channel == null || channel.getId() < 0) {
            Logger.log("Cannot disassociate as missing parameter(s)");
            return;
        }
        try {
            Statement s = this.connection.createStatement();
            String sql = "delete from subjectchannel where  fk_subject_id=" + subject.getId() + " and " + " fk_channel_id=" + channel.getId();
            Logger.log(sql);
            s.executeUpdate(sql);
            s.close();
            this.view.popup("Removed subject/channel " + subject.getTitle() + "/" + channel.getTitle());
            this.view.repopulateSubjects();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

