/*
 * Decompiled with CFR 0.152.
 */
package com.javanicus.blogmento;

import com.javanicus.blogmento.BlogState;
import com.javanicus.blogmento.FunnyMaths;
import com.javanicus.blogmento.Logger;
import com.javanicus.blogmento.Template;
import com.javanicus.blogmento.Utilities;
import java.io.BufferedWriter;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.util.Properties;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class TemplateEngine {
    VelocityEngine ve = null;

    public TemplateEngine() {
        try {
            this.ve = new VelocityEngine();
            String stylePath = System.getProperty("styles");
            Properties p = new Properties();
            p.setProperty("file.resource.loader.path", stylePath);
            p.setProperty("runtime.log.logsystem.class", "org.apache.velocity.runtime.log.NullLogSystem");
            this.ve.init(p);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doTemplate(PrintStream out, String templateFileName, BlogState state, Template tt) throws Exception {
        Logger.log("TemplateEngine.doTemplate(" + out + "," + templateFileName + ")");
        VelocityContext context = new VelocityContext();
        org.apache.velocity.Template t = this.ve.getTemplate(templateFileName);
        context.put("items", (Object)state.getItems());
        context.put("subjects", (Object)state.getSubjects());
        context.put("currentSubject", (Object)state.getCurrentSubject());
        context.put("channel", (Object)state.getCurrentChannel());
        context.put("dirPrefix", (Object)state.getDirPrefix());
        context.put("calendar", (Object)state.getCalendar());
        context.put("outputFile", (Object)tt.getOutputFile());
        context.put("utils", (Object)new Utilities());
        context.put("maths", (Object)new FunnyMaths());
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out));
        t.merge((Context)context, (Writer)writer);
        writer.flush();
    }
}

