/*
 * Decompiled with CFR 0.152.
 */
package com.javanicus.blogmento;

import com.javanicus.blogmento.Logger;
import com.javanicus.blogmento.PrintCommandListener;
import com.javanicus.blogmento.Transport;
import com.javanicus.blogmento.Utilities;
import com.oroinc.net.ProtocolCommandListener;
import com.oroinc.net.ftp.FTPClient;
import com.oroinc.net.ftp.FTPConnectionClosedException;
import com.oroinc.net.ftp.FTPReply;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class TransportFTP
implements Transport {
    public List getParameterList() {
        ArrayList<String> p = new ArrayList<String>();
        p.add("username");
        p.add("password");
        p.add("server");
        p.add("remoteDir");
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upload(String directory, List fileList, Properties protocolDetails) {
        String server = protocolDetails.getProperty("server");
        String username = protocolDetails.getProperty("username");
        String password = protocolDetails.getProperty("password");
        String remoteDir = protocolDetails.getProperty("remoteDir");
        remoteDir = Utilities.addTrailingSlashIfNecessary(remoteDir);
        FTPClient ftp = new FTPClient();
        ftp.addProtocolCommandListener((ProtocolCommandListener)new PrintCommandListener(new PrintWriter(System.out)));
        try {
            ftp.connect(server);
            System.out.println("Connected to " + server + ".");
            int reply = ftp.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                ftp.disconnect();
                System.err.println("FTP server refused connection.");
                throw new RuntimeException("FTP server refused connection.");
            }
        }
        catch (IOException e) {
            if (ftp.isConnected()) {
                try {
                    ftp.disconnect();
                }
                catch (IOException f) {
                    // empty catch block
                }
            }
            System.err.println("Could not connect to server.");
            e.printStackTrace();
            throw new RuntimeException("Could not connect to server.");
        }
        try {
            if (!ftp.login(username, password)) {
                ftp.logout();
            } else {
                System.out.println("Remote system is " + ftp.getSystemName());
                ftp.setFileType(2);
                if (!this.alreadyCreatedRemoteSubDirectories(ftp, remoteDir)) {
                    ftp.makeDirectory("days");
                    ftp.makeDirectory("export");
                    ftp.makeDirectory("items");
                    ftp.makeDirectory("months");
                    ftp.makeDirectory("subjects)");
                }
                Iterator itr = fileList.iterator();
                while (itr.hasNext()) {
                    String fileName = (String)itr.next();
                    Logger.log("localFile:" + directory + fileName);
                    FileInputStream input = new FileInputStream(directory + fileName);
                    Logger.log("remoteFile:" + remoteDir + fileName);
                    ftp.storeFile(remoteDir + fileName, (InputStream)input);
                }
                ftp.logout();
            }
        }
        catch (FTPConnectionClosedException e) {
            System.err.println("Server closed connection.");
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (ftp.isConnected()) {
                try {
                    ftp.disconnect();
                }
                catch (IOException f) {}
            }
        }
    }

    private boolean alreadyCreatedRemoteSubDirectories(FTPClient ftp, String remoteDir) throws IOException {
        String[] names = ftp.listNames(remoteDir);
        boolean alreadyCreatedRemoteSubDirectories = false;
        for (int i = 0; i < names.length; ++i) {
            if (!"items".equals(names[i])) continue;
            alreadyCreatedRemoteSubDirectories = true;
        }
        return alreadyCreatedRemoteSubDirectories;
    }
}

