/*
 * Decompiled with CFR 0.152.
 */
package com.javanicus.blogmento;

import com.javanicus.blogmento.Logger;
import com.javanicus.blogmento.Transport;
import com.javanicus.blogmento.Utilities;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import mindbright.ssh.SSHAuthenticator;
import mindbright.ssh.SSHPasswordAuthenticator;
import mindbright.ssh.SSHSCP;

public class TransportSCP
implements Transport {
    public List getParameterList() {
        ArrayList<String> p = new ArrayList<String>();
        p.add("sshHost");
        p.add("port");
        p.add("username");
        p.add("password");
        p.add("remoteDir");
        return p;
    }

    public void upload(String directory, List fileList, Properties protocolDetails) {
        String sshHost = protocolDetails.getProperty("sshHost");
        String p = protocolDetails.getProperty("port");
        String username = protocolDetails.getProperty("username");
        String password = protocolDetails.getProperty("password");
        String remoteDir = protocolDetails.getProperty("remoteDir");
        int port = Integer.parseInt(p);
        remoteDir = Utilities.addTrailingSlashIfNecessary(remoteDir);
        try {
            System.out.println(sshHost + ":" + port + " - " + username + "/" + password + " - " + new File("."));
            SSHSCP scp = new SSHSCP(sshHost, port, (SSHAuthenticator)new SSHPasswordAuthenticator(username, password), new File("."), true, true);
            Iterator itr = fileList.iterator();
            while (itr.hasNext()) {
                String fileName = (String)itr.next();
                Logger.log("localFile:" + directory + fileName);
                Logger.log("remoteFile:" + remoteDir + fileName);
                System.out.println(directory + fileName + "  ->  " + remoteDir + fileName);
                scp.copyToRemote(directory + fileName, remoteDir + fileName);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

