/*
 * Decompiled with CFR 0.152.
 */
package com.javanicus.blogmento;

import com.javanicus.blogmento.BlogState;
import com.javanicus.blogmento.Blogmento;
import com.javanicus.blogmento.Channel;
import com.javanicus.blogmento.Logger;
import com.javanicus.blogmento.Prefs;
import com.javanicus.blogmento.Transport;
import com.javanicus.blogmento.TransportFactory;
import com.javanicus.blogmento.Utilities;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import thinlet.Thinlet;

public class Wizard
extends Thinlet {
    private BlogState state;
    private Blogmento view;
    private static final String DEFAULT_NAME = "blog";
    private WindowListener windowListener;

    public Wizard(BlogState state, Blogmento view) {
        this.state = state;
        this.view = view;
        try {
            this.add(this.parse("wizard.xml"));
            this.initialise();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void setWindowListener(WindowListener windowListener) {
        this.windowListener = windowListener;
    }

    public void initialise() {
        this.setString(this.find("outputDir"), "text", this.state.getPrefs().getWorkingDirectory());
    }

    public void outputDirPressed() {
        Logger.log("wizard.outputDirPressed()");
        FileDialog fd = new FileDialog(Frame.getFrames()[0], "Output dir...", 0);
        fd.setDirectory(this.getString(this.find("outputDir"), "text"));
        fd.show();
        this.setString(this.find("outputDir"), "text", fd.getDirectory() + fd.getFile());
    }

    public void channelTransportPressed() {
        Channel dummyChannel = new Channel();
        dummyChannel.setTransportType(this.getString(this.find("channelTransport"), "text"));
        dummyChannel.setTitle(DEFAULT_NAME);
        dummyChannel.setTransportPropertyFile(this.getTPF(dummyChannel));
        this.populateTransport(dummyChannel);
    }

    private String getTPF(Channel c) {
        return Utilities.getSafeForFilename(c.getTitle() + ".properties");
    }

    public void populateTransport(Channel c) {
        Logger.log("wizard.populateTransport(" + c + ")");
        this.setString(this.find("channelTransport"), "text", c.getTransportType());
        this.clearList("transportDetails");
        Transport t = TransportFactory.getInstance(c.getTransportType());
        if (t != null) {
            List params = t.getParameterList();
            Properties protocolDetails = new Properties();
            try {
                String propertyPath = this.state.getPrefs().getWorkingDirectory() + "/blogmento/";
                protocolDetails.load(new FileInputStream(propertyPath + c.getTransportPropertyFile()));
            }
            catch (Exception e) {
                Logger.log(e.toString());
            }
            Iterator itr = params.iterator();
            while (itr.hasNext()) {
                String p = (String)itr.next();
                Object row = this.create("row");
                Object param = this.create("cell");
                this.setString(param, "text", p);
                this.add(row, param);
                Object value = this.create("cell");
                this.setString(value, "text", protocolDetails.getProperty(p));
                this.add(row, value);
                this.add(this.find("transportDetails"), row);
            }
        }
        this.setString(this.find("transportKey"), "text", "");
        this.setString(this.find("transportValue"), "text", "");
    }

    public void transportDetailsSelected() {
        Logger.log("transportDetailsSelected()");
        int j = this.getSelectedIndex(this.find("transportDetails"));
        if (j > -1) {
            Object row = this.getItem(this.find("transportDetails"), "row", j);
            String key = this.getString(this.getItem(row, "cell", 0), "text");
            String value = this.getString(this.getItem(row, "cell", 1), "text");
            this.setString(this.find("transportKey"), "text", key);
            this.setString(this.find("transportValue"), "text", value);
        }
    }

    public void updateTransportValueTypedInto() {
        Object row;
        String key2;
        Logger.log("updateTransportValueTypedInto()");
        String key = this.getString(this.find("transportKey"), "text");
        String value = this.getString(this.find("transportValue"), "text");
        int j = this.getSelectedIndex(this.find("transportDetails"));
        if (j > -1 && key.equals(key2 = this.getString(this.getItem(row = this.getItem(this.find("transportDetails"), "row", j), "cell", 0), "text"))) {
            this.setString(this.getItem(row, "cell", 1), "text", value);
            this.setSelectedIndex(this.find("transportDetails"), j);
        }
    }

    public void cancelPressed() {
        this.windowListener.windowClosing(null);
    }

    public void saveDetailsPressed() {
        Prefs unsavedPrefs = this.state.getPrefs();
        unsavedPrefs.setWorkingDirectory(this.getString(this.find("outputDir"), "text"));
        this.state.getDao().savePreferences(unsavedPrefs);
        File d = new File(this.state.getPrefs().getWorkingDirectory() + "/blogmento");
        if (!d.exists()) {
            d.mkdirs();
        }
        Channel unsavedChannel = this.state.getManageChannel();
        unsavedChannel.setTitle(DEFAULT_NAME);
        unsavedChannel.setLink(this.getString(this.find("channelLink"), "text"));
        unsavedChannel.setDescription("my thoughts...");
        unsavedChannel.setTransportType(this.getString(this.find("channelTransport"), "text"));
        unsavedChannel.setTransportPropertyFile(this.getTPF(unsavedChannel));
        unsavedChannel.setStyle("clean");
        unsavedChannel.setRecentItemCount(15);
        Properties protocolDetails = new Properties();
        Object[] o = this.getItems(this.find("transportDetails"));
        for (int j = 0; j < o.length; ++j) {
            String key = this.getString(this.getItem(o[j], "cell", 0), "text");
            String value = this.getString(this.getItem(o[j], "cell", 1), "text");
            if (key == null || value == null) continue;
            protocolDetails.setProperty(key, value);
        }
        try {
            Logger.log(protocolDetails.toString());
            String propertyPath = this.state.getPrefs().getWorkingDirectory() + "/blogmento/";
            System.out.println("Saving protocol details to " + propertyPath + unsavedChannel.getTransportPropertyFile());
            protocolDetails.store(new FileOutputStream(propertyPath + unsavedChannel.getTransportPropertyFile()), "Blogmento '" + unsavedChannel.getTransportType() + "' details for '" + unsavedChannel.getTitle() + "'");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.state.getDao().saveChannel(unsavedChannel);
        this.view.update();
        this.windowListener.windowClosing(null);
    }

    public void clearList(String objectName) {
        Logger.log("clearList(" + objectName + ")");
        Object list = this.find(objectName);
        for (int ii = this.getCount(list) - 1; ii >= 0; --ii) {
            Object item = this.getItem(list, ii);
            this.remove(item);
        }
    }
}

