/*
 * Decompiled with CFR 0.152.
 */
package mindbright.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import mindbright.net.ProxyAuthenticator;

public class SocksProxySocket
extends Socket {
    private static final String[] replyErrorV5 = new String[]{"Success", "General SOCKS server failure", "Connection not allowed by ruleset", "Network unreachable", "Host unreachable", "Connection refused", "TTL expired", "Command not supported", "Address type not supported"};
    private static final String[] replyErrorV4 = new String[]{"Request rejected or failed", "SOCKS server cannot connect to identd on the client", "The client program and identd report different user-ids"};
    private String proxyHost;
    private int proxyPort;
    private String targetHost;
    private int targetPort;
    String serverDesc;

    public String getServerDesc() {
        return this.serverDesc;
    }

    private SocksProxySocket(String string, int n, String string2, int n2) throws IOException, UnknownHostException {
        super(string2, n2);
        this.proxyHost = string2;
        this.proxyPort = n2;
        this.targetHost = string;
        this.targetPort = n;
    }

    public static SocksProxySocket getSocks4Proxy(String string, int n, String string2, int n2, String string3) throws IOException, UnknownHostException {
        SocksProxySocket socksProxySocket = new SocksProxySocket(string, n, string2, n2);
        try {
            InputStream inputStream = socksProxySocket.getInputStream();
            OutputStream outputStream = socksProxySocket.getOutputStream();
            InetAddress inetAddress = InetAddress.getByName(string);
            outputStream.write(4);
            outputStream.write(1);
            outputStream.write(n >>> 8 & 0xFF);
            outputStream.write(n & 0xFF);
            outputStream.write(inetAddress.getAddress());
            outputStream.write(string3.getBytes());
            outputStream.write(0);
            outputStream.flush();
            int n3 = inputStream.read();
            if (n3 == -1) {
                throw new IOException("SOCKS4 server " + string2 + ":" + n2 + " disconnected");
            }
            if (n3 != 0) {
                throw new IOException("Invalid response from SOCKS4 server (" + n3 + ") " + string2 + ":" + n2);
            }
            int n4 = inputStream.read();
            if (n4 != 90) {
                if (n4 > 90 && n4 < 93) {
                    throw new IOException("SOCKS4 server unable to connect, reason: " + replyErrorV4[n4 - 91]);
                }
                throw new IOException("SOCKS4 server unable to connect, reason: " + n4);
            }
            byte[] byArray = new byte[6];
            if (inputStream.read(byArray, 0, 6) != 6) {
                throw new IOException("SOCKS4 error reading destination address/port");
            }
            socksProxySocket.serverDesc = byArray[2] + "." + byArray[3] + "." + byArray[4] + "." + byArray[5] + ":" + (byArray[0] << 8 | byArray[1]);
        }
        catch (SocketException socketException) {
            throw new SocketException("Error communicating with SOCKS4 server " + string2 + ":" + n2 + ", " + socketException.getMessage());
        }
        return socksProxySocket;
    }

    public static SocksProxySocket getSocks5Proxy(String string, int n, String string2, int n2, boolean bl, ProxyAuthenticator proxyAuthenticator) throws IOException, UnknownHostException {
        SocksProxySocket socksProxySocket = new SocksProxySocket(string, n, string2, n2);
        try {
            InputStream inputStream = socksProxySocket.getInputStream();
            OutputStream outputStream = socksProxySocket.getOutputStream();
            byte[] byArray = new byte[]{5, 2, 0, 2};
            byte[] byArray2 = new byte[2];
            outputStream.write(byArray);
            outputStream.flush();
            int n3 = inputStream.read();
            if (n3 == -1) {
                throw new IOException("SOCKS5 server " + string2 + ":" + n2 + " disconnected");
            }
            if (n3 != 5) {
                throw new IOException("Invalid response from SOCKS5 server (" + n3 + ") " + string2 + ":" + n2);
            }
            int n4 = inputStream.read();
            switch (n4) {
                case 0: {
                    break;
                }
                case 2: {
                    SocksProxySocket.doAuthentication(inputStream, outputStream, proxyAuthenticator, string2, n2);
                    break;
                }
                default: {
                    throw new IOException("SOCKS5 server does not support our authentication methods");
                }
            }
            if (bl) {
                InetAddress inetAddress;
                try {
                    inetAddress = InetAddress.getByName(string);
                }
                catch (UnknownHostException unknownHostException) {
                    throw new IOException("Can't do local lookup on: " + string + ", try socks5 without local lookup");
                }
                byArray = new byte[]{5, 1, 0, 1};
                outputStream.write(byArray);
                outputStream.write(inetAddress.getAddress());
            } else {
                byArray = new byte[]{5, 1, 0, 3};
                outputStream.write(byArray);
                outputStream.write(string.length());
                outputStream.write(string.getBytes());
            }
            outputStream.write(n >>> 8 & 0xFF);
            outputStream.write(n & 0xFF);
            outputStream.flush();
            n3 = inputStream.read();
            if (n3 != 5) {
                throw new IOException("Invalid response from SOCKS5 server (" + n3 + ") " + string2 + ":" + n2);
            }
            int n5 = inputStream.read();
            if (n5 != 0) {
                if (n5 > 0 && n5 < 9) {
                    throw new IOException("SOCKS5 server unable to connect, reason: " + replyErrorV5[n5]);
                }
                throw new IOException("SOCKS5 server unable to connect, reason: " + n5);
            }
            inputStream.read();
            int n6 = inputStream.read();
            byte[] byArray3 = new byte[255];
            switch (n6) {
                case 1: {
                    if (inputStream.read(byArray3, 0, 4) != 4) {
                        throw new IOException("SOCKS5 error reading address");
                    }
                    socksProxySocket.serverDesc = byArray3[0] + "." + byArray3[1] + "." + byArray3[2] + "." + byArray3[3];
                    break;
                }
                case 3: {
                    int n7 = inputStream.read();
                    if (inputStream.read(byArray3, 0, n7) != n7) {
                        throw new IOException("SOCKS5 error reading address");
                    }
                    socksProxySocket.serverDesc = new String(byArray3);
                    break;
                }
                default: {
                    throw new IOException("SOCKS5 gave unsupported address type: " + n6);
                }
            }
            if (inputStream.read(byArray3, 0, 2) != 2) {
                throw new IOException("SOCKS5 error reading port");
            }
            socksProxySocket.serverDesc = socksProxySocket.serverDesc + ":" + (byArray3[0] << 8 | byArray3[1]);
        }
        catch (SocketException socketException) {
            throw new SocketException("Error communicating with SOCKS5 server " + string2 + ":" + n2 + ", " + socketException.getMessage());
        }
        return socksProxySocket;
    }

    static void doAuthentication(InputStream inputStream, OutputStream outputStream, ProxyAuthenticator proxyAuthenticator, String string, int n) throws IOException {
        String string2 = proxyAuthenticator.getProxyUsername("SOCKS5", null);
        String string3 = proxyAuthenticator.getProxyPassword("SOCKS5", null);
        outputStream.write(1);
        outputStream.write(string2.length());
        outputStream.write(string2.getBytes());
        outputStream.write(string3.length());
        outputStream.write(string3.getBytes());
        int n2 = inputStream.read();
        if (n2 != 5) {
            throw new IOException("Invalid response from SOCKS5 server (" + n2 + ") " + string + ":" + n);
        }
        if (inputStream.read() != 0) {
            throw new IOException("Invalid username/password for SOCKS5 server");
        }
    }

    public String toString() {
        return "SocksProxySocket[addr=" + this.getInetAddress() + ",port=" + this.getPort() + ",localport=" + this.getLocalPort() + "]";
    }
}

