/*
 * Decompiled with CFR 0.152.
 */
package mindbright.ssh;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxMenuItem;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import mindbright.application.MindTerm;
import mindbright.gui.ProgressBar;
import mindbright.security.SecureRandom;
import mindbright.ssh.SSH;
import mindbright.ssh.SSHCaptureConsole;
import mindbright.ssh.SSHClient;
import mindbright.ssh.SSHInteractiveClient;
import mindbright.ssh.SSHMenuHandler;
import mindbright.ssh.SSHMiscDialogs;
import mindbright.ssh.SSHProxyDialog;
import mindbright.ssh.SSHSCPDialog;
import mindbright.ssh.SSHTunnelDialog;
import mindbright.terminal.TerminalMenuHandlerFull;
import mindbright.terminal.TerminalMenuListener;
import mindbright.terminal.TerminalWin;
import mindbright.util.AWTConvenience;

public final class SSHMenuHandlerFull
extends SSHMenuHandler
implements ActionListener,
ItemListener,
TerminalMenuListener {
    String aboutText = "Copyright (c) 1998,99 by Mindbright Technology AB, Stockholm, Sweden.\n\nThis program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.\n\nThis program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.\n\n\tAuthor:\tMats Andersson (mats@mindbright.se)\n\tWeb:\thttp://www.mindbright.se/mindterm/\n\tInfo:\tmindterm@mindbright.se\n\tCVS $Name:  $\n\tCVS $Date: 2001/02/08 18:42:12 $\nRunning on:\n\tJava vendor:\t" + MindTerm.javaVendor + "\n" + "\tJava version:\t" + MindTerm.javaVersion + "\n" + "\tOS name:\t" + MindTerm.osName + "\n" + "\tOS architecture:\t" + MindTerm.osArch + "\n" + "\tOS version:\t" + MindTerm.osVersion + "\n";
    SSHInteractiveClient client;
    Frame parent;
    TerminalWin term;
    MindTerm mindterm;
    boolean havePopupMenu = false;
    static final int MENU_FILE = 0;
    static final int MENU_EDIT = 1;
    static final int MENU_SETTINGS = 2;
    static final int MENU_TUNNELS = 3;
    static final int MENU_HELP = 4;
    static final int M_FILE_NEW = 1;
    static final int M_FILE_CLONE = 2;
    static final int M_FILE_CONN = 3;
    static final int M_FILE_DISC = 4;
    static final int M_FILE_LOAD = 6;
    static final int M_FILE_SAVE = 7;
    static final int M_FILE_SAVEAS = 8;
    static final int M_FILE_CREATID = 10;
    static final int M_FILE_SCP = 12;
    static final int M_FILE_CAPTURE = 13;
    static final int M_FILE_SEND = 14;
    static final int M_FILE_CLOSE = 16;
    static final int M_FILE_EXIT = 17;
    static final int M_EDIT_COPY = 1;
    static final int M_EDIT_PASTE = 2;
    static final int M_EDIT_CPPASTE = 3;
    static final int M_EDIT_SELALL = 4;
    static final int M_EDIT_FIND = 5;
    static final int M_EDIT_CLS = 7;
    static final int M_EDIT_CLEARSB = 8;
    static final int M_EDIT_VTRESET = 9;
    static final int M_SET_SSH = 1;
    static final int M_SET_TERM = 2;
    static final int M_SET_MISC = 3;
    static final int M_SET_PROXY = 4;
    static final int M_SET_CMDSH = 6;
    static final int M_SET_AUTOSAVE = 8;
    static final int M_SET_AUTOLOAD = 9;
    static final int M_SET_SAVEPWD = 10;
    static final int M_TUNL_SIMPLE = 1;
    static final int M_TUNL_ADVANCED = 2;
    static final int M_TUNL_CURRENT = 4;
    static final int M_HELP_TOPICS = 1;
    static final int M_HELP_ABOUT = 2;
    static final String[][] menuTexts = new String[][]{{"File", "New Terminal", "Clone Terminal", "Connect...", "Disconnect", null, "Load Settings...", "Save Settings", "Save Settings As...", null, "Create RSA Identity...", null, "SCP File Transfer...", "_Capture To File...", "Send ASCII File...", null, "Close", "Exit"}, {"Edit", "Copy Ctrl+Ins", "Paste Shift+Ins", "Copy & Paste", "Select All", "Find...", null, "Clear Screen", "Clear Scrollback", "VT Reset"}, {"Settings", "SSH Connection...", "Terminal...", "Terminal Misc...", "Proxy...", null, "Local Command-Shell", null, "_Auto Save Settings", "_Auto Load Settings", "_Save Passwords"}, {"Tunnels", "Basic...", "Advanced...", null, "Current Connections..."}, {"Help", "Help Topics...", "About MindTerm"}};
    static final int NO_SHORTCUT = -1;
    static final int[][] menuShortCuts = new int[][]{{-1, 78, 79, 67, -1, -1, -1, 83, -1, -1, -1, -1, -1, -1, -1, -1, 69, 88}, {-1, -1, -1, -1, 65, 70, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, 72, 84, 77, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}};
    Object[][] menuItems;
    int popButtonNum = 3;
    Dialog settingsDialog = null;
    Choice choiceCipher;
    Choice choiceAuthTyp;
    Checkbox cbX11;
    Checkbox cbPrvPrt;
    Checkbox cbRemFwd;
    Checkbox cbIdHost;
    Checkbox cbPortFtp;
    Checkbox cbLocHst;
    Checkbox cbMTU;
    Checkbox cbAlive;
    Checkbox cbForcPty;
    TextField textPort;
    TextField textUser;
    TextField textId;
    TextField textDisp;
    TextField textMtu;
    TextField textAlive;
    TextField textSrv;
    TextField textRealAddr;
    TextField textAuthList;
    TextField textLocHost;
    Label lblAlert;
    String[] cipher;
    String[] authtyp;
    String[] bool;
    FileDialog idFileFD;
    Button idFileBut;
    Button advButton;
    boolean newServer;
    boolean advanced = false;
    Panel ap;
    Dialog currentTunnelsDialog = null;
    List currList;
    TunnelEditor localEdit = null;
    TunnelEditor remoteEdit = null;
    Dialog tunnelDialog = null;
    Dialog connectDialog = null;
    List hostList;
    boolean wantToRunSettingsDialog = false;
    FileDialog loadFileDialog = null;
    FileDialog saveAsFileDialog = null;
    FileDialog sendFileDialog = null;
    SSHCaptureConsole captureConsole;
    FileDialog captureToFileDialog = null;
    static final String keyGenerationHelp = "This will create a RSA identity which can be used with the RSA authentication method. Your identity will consist of two parts: public and private keys. Your private key will be saved in the location which you specify; the corresponding public key is saved in a file with an identical name but with an extension of '.pub' added to it.\n\nYour private key is protected by encryption, if you enter a password. If you leave the password field blank, the key will not be encrypted. This should only be used in protected environments where unattended logins are desired. The contents of the 'comment' field are stored with your key, and displayed each time you are prompted for the key's password.\n\nThe key is generated using a random number generator, which is seeded by mouse movement in the field containing this text. Please move the mouse around in here until the progress bar below registers 100%.\n\nTo use the key, you must transfer the '.pub' public key file to an SSH server and add the contents of it to the file 'authorized_keys' in your ssh directory (e.g. ~/.ssh) on the server. For convenience, your public key is also copied to the clipboard.";
    Dialog keyGenerationDialog;
    FileDialog keyGenFD;
    TextField bitsText;
    TextField fileText;
    TextField pwdText;
    TextField pwdText2;
    TextField commText;
    TextArea descText;
    Checkbox useCheck;
    ProgressBar progBar;
    Label msgLbl;
    Button okBut;
    int randCnt = 0;
    int dummy = 0;
    byte[] randBytes = new byte[512];

    public void init(MindTerm mindTerm, SSHInteractiveClient sSHInteractiveClient, Frame frame, TerminalWin terminalWin) {
        this.mindterm = mindTerm;
        this.client = sSHInteractiveClient;
        this.parent = frame;
        this.term = terminalWin;
    }

    public void setPopupButton(int n) {
        this.term.setPopupButton(n);
        this.popButtonNum = n;
    }

    public int getPopupButton() {
        return this.popButtonNum;
    }

    Menu getMenu(int n) {
        Menu menu = new Menu(menuTexts[n][0]);
        int n2 = menuTexts[n].length;
        if (this.menuItems == null) {
            this.menuItems = new Object[menuTexts.length][];
        }
        if (this.menuItems[n] == null) {
            this.menuItems[n] = new Object[menuTexts[n].length];
        }
        int n3 = 1;
        while (n3 < n2) {
            String string = menuTexts[n][n3];
            if (string == null) {
                menu.addSeparator();
            } else {
                MenuItem menuItem;
                if (string.charAt(0) == '_') {
                    string = string.substring(1);
                    menuItem = new CheckboxMenuItem(string);
                    ((CheckboxMenuItem)menuItem).addItemListener(this);
                } else {
                    menuItem = new MenuItem(string);
                    menuItem.addActionListener(this);
                }
                if (menuShortCuts[n][n3] != -1) {
                    menuItem.setShortcut(new MenuShortcut(menuShortCuts[n][n3], true));
                }
                this.menuItems[n][n3] = menuItem;
                menu.add(menuItem);
            }
            ++n3;
        }
        return menu;
    }

    int[] mapAction(String string) {
        int[] nArray = new int[2];
        int n = 0;
        int n2 = 0;
        n = 0;
        while (n < menuTexts.length) {
            n2 = 1;
            while (n2 < menuTexts[n].length) {
                String string2 = menuTexts[n][n2];
                if (string2 != null && string.equals(string2)) {
                    nArray[0] = n;
                    nArray[1] = n2;
                    n = menuTexts.length;
                    break;
                }
                ++n2;
            }
            ++n;
        }
        return nArray;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int[] nArray = this.mapAction(((MenuItem)actionEvent.getSource()).getLabel());
        this.handleMenuAction(nArray);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        int[] nArray = this.mapAction("_" + (String)itemEvent.getItem());
        this.handleMenuAction(nArray);
    }

    public void handleMenuAction(int[] nArray) {
        block1 : switch (nArray[0]) {
            case 0: {
                switch (nArray[1]) {
                    case 1: {
                        this.mindterm.newWindow();
                        break;
                    }
                    case 2: {
                        this.mindterm.cloneWindow();
                        break;
                    }
                    case 3: {
                        this.connectDialog();
                        break;
                    }
                    case 4: {
                        if (!this.mindterm.confirmClose()) break;
                        this.client.forcedDisconnect();
                        this.client.quiet = this.client.initQuiet;
                        break;
                    }
                    case 6: {
                        this.loadFileDialog();
                        break;
                    }
                    case 7: {
                        try {
                            if (this.client.propsHandler.savePasswords && this.client.propsHandler.emptyPropertyPassword()) {
                                String string = this.setPasswordDialog("Please set password for alias " + this.client.propsHandler.currentAlias, "MindTerm - Set File Password");
                                if (string == null) {
                                    return;
                                }
                                this.client.propsHandler.setPropertyPassword(string);
                            }
                            this.client.propsHandler.saveCurrentFile();
                        }
                        catch (Throwable throwable) {
                            this.alertDialog("Error saving settings: " + throwable.getMessage());
                        }
                        break;
                    }
                    case 8: {
                        this.saveAsFileDialog();
                        break;
                    }
                    case 10: {
                        this.keyGenerationDialog();
                        break;
                    }
                    case 12: {
                        this.client.quiet = true;
                        SSHSCPDialog.show("MindTerm - File Transfer", this.parent, this.client.propsHandler, this.client);
                        break;
                    }
                    case 13: {
                        if (((CheckboxMenuItem)this.menuItems[0][13]).getState()) {
                            if (this.captureToFileDialog()) break;
                            ((CheckboxMenuItem)this.menuItems[0][13]).setState(false);
                            break;
                        }
                        this.endCapture();
                        break;
                    }
                    case 14: {
                        this.sendFileDialog();
                        break;
                    }
                    case 16: {
                        this.mindterm.close();
                        break;
                    }
                    case 17: {
                        this.mindterm.exit();
                    }
                }
                break;
            }
            case 1: {
                switch (nArray[1]) {
                    case 1: {
                        this.term.doCopy();
                        break;
                    }
                    case 2: {
                        this.term.doPaste();
                        break;
                    }
                    case 3: {
                        this.term.doCopy();
                        this.term.doPaste();
                        break;
                    }
                    case 4: {
                        this.term.selectAll();
                        break;
                    }
                    case 5: {
                        ((TerminalMenuHandlerFull)this.term.getMenus()).findDialog();
                        break;
                    }
                    case 7: {
                        this.term.clearScreen();
                        this.term.cursorSetPos(0, 0, false);
                        break;
                    }
                    case 8: {
                        this.term.clearSaveLines();
                        break;
                    }
                    case 9: {
                        this.term.resetInterpreter();
                    }
                }
                break;
            }
            case 2: {
                switch (nArray[1]) {
                    case 1: {
                        this.sshSettingsDialog();
                        break;
                    }
                    case 2: {
                        ((TerminalMenuHandlerFull)this.term.getMenus()).termSettingsDialog();
                        break;
                    }
                    case 3: {
                        ((TerminalMenuHandlerFull)this.term.getMenus()).termSettingsDialog2();
                        break;
                    }
                    case 4: {
                        SSHProxyDialog.show("MindTerm - Proxy Settings", this.parent, this.client.propsHandler);
                        break;
                    }
                    case 6: {
                        this.client.console.println("");
                        this.client.console.println("** hit a key to enter local command-shell **");
                        this.client.sshStdIO.wantCommandShell();
                        break;
                    }
                    case 8: {
                        this.client.propsHandler.setAutoSaveProps(((CheckboxMenuItem)this.menuItems[2][8]).getState());
                        this.update();
                        break;
                    }
                    case 9: {
                        this.client.propsHandler.setAutoLoadProps(((CheckboxMenuItem)this.menuItems[2][9]).getState());
                        this.update();
                        break;
                    }
                    case 10: {
                        this.client.propsHandler.setSavePasswords(((CheckboxMenuItem)this.menuItems[2][10]).getState());
                        if (!this.client.propsHandler.savePasswords || !this.client.propsHandler.emptyPropertyPassword() || this.client.propsHandler.getAlias() == null) break;
                        String string = this.setPasswordDialog("Please set password for alias " + this.client.propsHandler.currentAlias, "MindTerm - Set File Password");
                        if (string == null) {
                            this.client.propsHandler.setSavePasswords(false);
                            this.update();
                            return;
                        }
                        this.client.propsHandler.setPropertyPassword(string);
                    }
                }
                break;
            }
            case 3: {
                switch (nArray[1]) {
                    case 1: {
                        SSHTunnelDialog.show("MindTerm - Basic Tunnels Setup", this.client, this.client.propsHandler, this.parent);
                        break;
                    }
                    case 2: {
                        this.advancedTunnelsDialog();
                        break;
                    }
                    case 4: {
                        this.currentTunnelsDialog();
                    }
                }
                break;
            }
            case 4: {
                switch (nArray[1]) {
                    case 1: {
                        this.alertDialog("No help available yet, be patient :-)");
                        break block1;
                    }
                    case 2: {
                        this.textDialog("About MindTerm v1.2.1SCP3", this.aboutText, 15, 60, true);
                    }
                }
            }
        }
    }

    public void update() {
        boolean bl = this.client.isOpened();
        boolean bl2 = this.client.isConnected();
        ((MenuItem)this.menuItems[2][6]).setEnabled(bl && this.client.sshStdIO.hasCommandShell());
        ((MenuItem)this.menuItems[0][12]).setEnabled(bl);
        ((MenuItem)this.menuItems[0][14]).setEnabled(bl);
        ((MenuItem)this.menuItems[0][8]).setEnabled(bl && this.client.propsHandler.getSSHHomeDir() != null);
        ((MenuItem)this.menuItems[3][4]).setEnabled(bl);
        ((MenuItem)this.menuItems[3][1]).setEnabled(bl);
        ((MenuItem)this.menuItems[3][2]).setEnabled(bl);
        ((MenuItem)this.menuItems[0][3]).setEnabled(!bl2);
        ((MenuItem)this.menuItems[0][4]).setEnabled(bl2);
        ((MenuItem)this.menuItems[0][6]).setEnabled(!bl2);
        ((MenuItem)this.menuItems[0][7]).setEnabled(this.client.propsHandler.wantSave());
        ((CheckboxMenuItem)this.menuItems[2][8]).setState(this.client.propsHandler.autoSaveProps);
        ((CheckboxMenuItem)this.menuItems[2][9]).setState(this.client.propsHandler.autoLoadProps);
        ((CheckboxMenuItem)this.menuItems[2][10]).setState(this.client.propsHandler.savePasswords);
        boolean bl3 = this.client.sshStdIO.selectionAvailable;
        ((MenuItem)this.menuItems[1][1]).setEnabled(bl3);
        ((MenuItem)this.menuItems[1][3]).setEnabled(bl3);
    }

    public void prepareMenuBar(MenuBar menuBar) {
        menuBar.add(this.getMenu(0));
        menuBar.add(this.getMenu(1));
        menuBar.add(this.getMenu(2));
        menuBar.add(((TerminalMenuHandlerFull)this.term.getMenus()).getOptionsMenu());
        menuBar.add(this.getMenu(3));
        menuBar.setHelpMenu(this.getMenu(4));
        this.update();
    }

    public void preparePopupMenu(PopupMenu popupMenu) {
        this.havePopupMenu = true;
        popupMenu.add(this.getMenu(0));
        popupMenu.add(this.getMenu(1));
        popupMenu.add(this.getMenu(2));
        popupMenu.add(((TerminalMenuHandlerFull)this.term.getMenus()).getOptionsMenu());
        popupMenu.add(this.getMenu(3));
        popupMenu.addSeparator();
        popupMenu.add(this.getMenu(4));
        this.update();
    }

    public final void sshSettingsDialog() {
        Object object;
        Serializable serializable;
        Object object2;
        if (this.settingsDialog == null) {
            this.cipher = SSH.getCiphers();
            this.authtyp = SSH.getAuthTypeList();
            this.settingsDialog = new Dialog(this.parent, true);
            object2 = new GridBagLayout();
            serializable = new GridBagConstraints();
            this.settingsDialog.setLayout((LayoutManager)object2);
            ((GridBagConstraints)serializable).fill = 2;
            ((GridBagConstraints)serializable).anchor = 17;
            ((GridBagConstraints)serializable).gridwidth = 1;
            ((GridBagConstraints)serializable).insets = new Insets(4, 4, 0, 4);
            ((GridBagConstraints)serializable).gridy = 0;
            object = new Label("Server:");
            ((GridBagLayout)object2).setConstraints((Component)object, (GridBagConstraints)serializable);
            this.settingsDialog.add((Component)object);
            ((GridBagConstraints)serializable).gridwidth = 3;
            this.textSrv = new TextField("", 16);
            ((GridBagLayout)object2).setConstraints(this.textSrv, (GridBagConstraints)serializable);
            this.settingsDialog.add(this.textSrv);
            ((GridBagConstraints)serializable).gridwidth = 1;
            object = new Label("Port:");
            ((GridBagLayout)object2).setConstraints((Component)object, (GridBagConstraints)serializable);
            this.settingsDialog.add((Component)object);
            this.textPort = new TextField("", 4);
            ((GridBagLayout)object2).setConstraints(this.textPort, (GridBagConstraints)serializable);
            this.settingsDialog.add(this.textPort);
            ((GridBagConstraints)serializable).gridy = 1;
            ((GridBagConstraints)serializable).gridwidth = 2;
            object = new Label("Username:");
            ((GridBagLayout)object2).setConstraints((Component)object, (GridBagConstraints)serializable);
            this.settingsDialog.add((Component)object);
            this.textUser = new TextField("", 10);
            ((GridBagLayout)object2).setConstraints(this.textUser, (GridBagConstraints)serializable);
            this.settingsDialog.add(this.textUser);
            object = new Label("Cipher:");
            ((GridBagConstraints)serializable).gridwidth = 1;
            ((GridBagLayout)object2).setConstraints((Component)object, (GridBagConstraints)serializable);
            this.settingsDialog.add((Component)object);
            this.choiceCipher = new Choice();
            int n = 0;
            while (n < this.cipher.length) {
                this.choiceCipher.add(this.cipher[n]);
                ++n;
            }
            ((GridBagLayout)object2).setConstraints(this.choiceCipher, (GridBagConstraints)serializable);
            this.settingsDialog.add(this.choiceCipher);
            ((GridBagConstraints)serializable).gridy = 4;
            ((GridBagConstraints)serializable).gridwidth = 2;
            object = new Label("Authentication:");
            ((GridBagLayout)object2).setConstraints((Component)object, (GridBagConstraints)serializable);
            this.settingsDialog.add((Component)object);
            this.choiceAuthTyp = new Choice();
            n = 0;
            while (n < this.authtyp.length) {
                this.choiceAuthTyp.add(this.authtyp[n]);
                ++n;
            }
            ((GridBagConstraints)serializable).gridwidth = 1;
            ((GridBagLayout)object2).setConstraints(this.choiceAuthTyp, (GridBagConstraints)serializable);
            this.settingsDialog.add(this.choiceAuthTyp);
            ItemListener itemListener = new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    SSHMenuHandlerFull.this.updateChoices();
                }
            };
            this.choiceAuthTyp.addItemListener(itemListener);
            ((GridBagConstraints)serializable).gridwidth = 3;
            this.textAuthList = new TextField("", 10);
            ((GridBagLayout)object2).setConstraints(this.textAuthList, (GridBagConstraints)serializable);
            this.settingsDialog.add(this.textAuthList);
            ((GridBagConstraints)serializable).gridy = 5;
            ((GridBagConstraints)serializable).gridwidth = 2;
            object = new Label("Identity:");
            ((GridBagLayout)object2).setConstraints((Component)object, (GridBagConstraints)serializable);
            this.settingsDialog.add((Component)object);
            ((GridBagConstraints)serializable).gridwidth = 3;
            this.textId = new TextField("", 16);
            ((GridBagLayout)object2).setConstraints(this.textId, (GridBagConstraints)serializable);
            this.settingsDialog.add(this.textId);
            this.idFileBut = new Button("...");
            this.idFileBut.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (SSHMenuHandlerFull.this.idFileFD == null) {
                        SSHMenuHandlerFull.this.idFileFD = new FileDialog(SSHMenuHandlerFull.this.parent, "MindTerm - Select file with identity (private)", 0);
                        SSHMenuHandlerFull.this.idFileFD.setDirectory(SSHMenuHandlerFull.this.client.propsHandler.getSSHHomeDir());
                    }
                    ((Component)SSHMenuHandlerFull.this.idFileFD).setVisible(true);
                    if (SSHMenuHandlerFull.this.idFileFD.getFile() != null && SSHMenuHandlerFull.this.idFileFD.getFile().length() > 0) {
                        SSHMenuHandlerFull.this.textId.setText(SSHMenuHandlerFull.this.idFileFD.getDirectory() + SSHMenuHandlerFull.this.idFileFD.getFile());
                    }
                }
            });
            ((GridBagConstraints)serializable).fill = 0;
            ((GridBagConstraints)serializable).gridwidth = 1;
            ((GridBagLayout)object2).setConstraints(this.idFileBut, (GridBagConstraints)serializable);
            this.settingsDialog.add(this.idFileBut);
            ((GridBagConstraints)serializable).gridy = 6;
            ((GridBagConstraints)serializable).gridwidth = 0;
            ((GridBagConstraints)serializable).fill = 0;
            ((GridBagConstraints)serializable).anchor = 13;
            ((GridBagConstraints)serializable).insets = new Insets(4, 0, 4, 8);
            Panel panel = new Panel(new FlowLayout());
            Button button = new Button("Configure Proxy");
            button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SSHProxyDialog.show("MindTerm - Proxy Settings", SSHMenuHandlerFull.this.parent, SSHMenuHandlerFull.this.client.propsHandler);
                }
            });
            panel.add(button);
            this.advButton = new Button("More options...");
            this.advButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (SSHMenuHandlerFull.this.advanced) {
                        SSHMenuHandlerFull.this.advButton.setLabel("More options...");
                        SSHMenuHandlerFull.this.settingsDialog.remove(SSHMenuHandlerFull.this.ap);
                    } else {
                        SSHMenuHandlerFull.this.advButton.setLabel("Less options...");
                        SSHMenuHandlerFull.this.settingsDialog.add(SSHMenuHandlerFull.this.ap);
                    }
                    SSHMenuHandlerFull.this.settingsDialog.pack();
                    SSHMenuHandlerFull.this.advanced = !SSHMenuHandlerFull.this.advanced;
                }
            });
            panel.add(this.advButton);
            ((GridBagLayout)object2).setConstraints(panel, (GridBagConstraints)serializable);
            this.settingsDialog.add(panel);
            this.ap = new Panel();
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(4, 4, 0, 4);
            this.ap.setLayout(gridBagLayout);
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            this.cbX11 = new Checkbox("X11 forward");
            gridBagLayout.setConstraints(this.cbX11, gridBagConstraints);
            this.ap.add(this.cbX11);
            this.cbX11.addItemListener(itemListener);
            object = new Label("Local X11-display:");
            gridBagConstraints.gridwidth = 3;
            gridBagLayout.setConstraints((Component)object, gridBagConstraints);
            this.ap.add((Component)object);
            this.textDisp = new TextField("", 12);
            gridBagConstraints.gridwidth = 1;
            gridBagLayout.setConstraints(this.textDisp, gridBagConstraints);
            this.ap.add(this.textDisp);
            gridBagConstraints.gridy = 1;
            this.cbMTU = new Checkbox("Set MTU");
            gridBagConstraints.gridwidth = 1;
            gridBagLayout.setConstraints(this.cbMTU, gridBagConstraints);
            this.ap.add(this.cbMTU);
            object = new Label("Max. packet size:");
            gridBagConstraints.gridwidth = 3;
            gridBagLayout.setConstraints((Component)object, gridBagConstraints);
            this.ap.add((Component)object);
            this.textMtu = new TextField("", 12);
            gridBagConstraints.gridwidth = 1;
            gridBagLayout.setConstraints(this.textMtu, gridBagConstraints);
            this.ap.add(this.textMtu);
            this.cbMTU.addItemListener(itemListener);
            gridBagConstraints.gridy = 2;
            this.cbAlive = new Checkbox("Send keep-alive");
            gridBagConstraints.gridwidth = 1;
            gridBagLayout.setConstraints(this.cbAlive, gridBagConstraints);
            this.ap.add(this.cbAlive);
            object = new Label("Interval (seconds):");
            gridBagConstraints.gridwidth = 3;
            gridBagLayout.setConstraints((Component)object, gridBagConstraints);
            this.ap.add((Component)object);
            this.textAlive = new TextField("", 12);
            gridBagConstraints.gridwidth = 1;
            gridBagLayout.setConstraints(this.textAlive, gridBagConstraints);
            this.ap.add(this.textAlive);
            this.cbAlive.addItemListener(itemListener);
            gridBagConstraints.gridy = 3;
            this.cbPortFtp = new Checkbox("Enable ftp PORT");
            gridBagConstraints.gridwidth = 1;
            gridBagLayout.setConstraints(this.cbPortFtp, gridBagConstraints);
            this.ap.add(this.cbPortFtp);
            object = new Label("Real sshd address:");
            gridBagConstraints.gridwidth = 3;
            gridBagLayout.setConstraints((Component)object, gridBagConstraints);
            this.ap.add((Component)object);
            this.textRealAddr = new TextField("", 12);
            gridBagConstraints.gridwidth = 1;
            gridBagLayout.setConstraints(this.textRealAddr, gridBagConstraints);
            this.ap.add(this.textRealAddr);
            this.cbPortFtp.addItemListener(itemListener);
            gridBagConstraints.gridy = 4;
            this.cbLocHst = new Checkbox("Set localhost");
            gridBagConstraints.gridwidth = 1;
            gridBagLayout.setConstraints(this.cbLocHst, gridBagConstraints);
            this.ap.add(this.cbLocHst);
            object = new Label("Localhost address:");
            gridBagConstraints.gridwidth = 3;
            gridBagLayout.setConstraints((Component)object, gridBagConstraints);
            this.ap.add((Component)object);
            this.textLocHost = new TextField("", 12);
            gridBagConstraints.gridwidth = 1;
            gridBagLayout.setConstraints(this.textLocHost, gridBagConstraints);
            this.ap.add(this.textLocHost);
            this.cbLocHst.addItemListener(itemListener);
            gridBagConstraints.gridy = 5;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.insets = new Insets(16, 4, 0, 4);
            this.cbIdHost = new Checkbox("Verify server key");
            gridBagLayout.setConstraints(this.cbIdHost, gridBagConstraints);
            this.ap.add(this.cbIdHost);
            this.cbForcPty = new Checkbox("Allocate PTY");
            gridBagLayout.setConstraints(this.cbForcPty, gridBagConstraints);
            this.ap.add(this.cbForcPty);
            gridBagConstraints.gridy = 6;
            this.cbPrvPrt = new Checkbox("Priv. source port");
            gridBagLayout.setConstraints(this.cbPrvPrt, gridBagConstraints);
            this.ap.add(this.cbPrvPrt);
            gridBagConstraints.gridwidth = 3;
            this.cbRemFwd = new Checkbox("Allow remote connects");
            gridBagLayout.setConstraints(this.cbRemFwd, gridBagConstraints);
            this.ap.add(this.cbRemFwd);
            ((GridBagConstraints)serializable).gridy = 7;
            ((GridBagConstraints)serializable).insets = new Insets(0, 0, 0, 0);
            ((GridBagConstraints)serializable).anchor = 10;
            ((GridBagConstraints)serializable).fill = 0;
            ((GridBagConstraints)serializable).gridwidth = 0;
            ((GridBagLayout)object2).setConstraints(this.ap, (GridBagConstraints)serializable);
            ((GridBagConstraints)serializable).insets = new Insets(0, 0, 0, 0);
            this.lblAlert = new Label("", 1);
            ((GridBagConstraints)serializable).gridy = 12;
            ((GridBagConstraints)serializable).fill = 2;
            ((GridBagLayout)object2).setConstraints(this.lblAlert, (GridBagConstraints)serializable);
            this.settingsDialog.add(this.lblAlert);
            panel = new Panel(new FlowLayout());
            Button button2 = new Button("OK");
            panel.add(button2);
            button2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        String string;
                        String string2 = null;
                        if (SSHMenuHandlerFull.this.newServer) {
                            string2 = SSHMenuHandlerFull.this.textSrv.getText();
                            if (string2.length() == 0) {
                                SSHMenuHandlerFull.this.lblAlert.setText("Please specify a server to connect to");
                                return;
                            }
                            SSHMenuHandlerFull.this.client.quiet = true;
                            SSHMenuHandlerFull.this.client.propsHandler.setProperty("server", string2);
                            SSHMenuHandlerFull.this.client.propsHandler.setAlias(string2);
                            string = SSHMenuHandlerFull.this.client.propsHandler.getProperty("prxpassword");
                            SSHMenuHandlerFull.this.client.propsHandler.clearPasswords();
                            if (string != null) {
                                SSHMenuHandlerFull.this.client.propsHandler.setProperty("prxpassword", string);
                            }
                            SSHMenuHandlerFull.this.client.propsHandler.clearAllForwards();
                        }
                        if ((string = SSHMenuHandlerFull.this.choiceAuthTyp.getSelectedItem()).equals("custom...")) {
                            SSHMenuHandlerFull.this.client.propsHandler.setProperty("authtyp", SSHMenuHandlerFull.this.textAuthList.getText());
                        } else {
                            SSHMenuHandlerFull.this.client.propsHandler.setProperty("authtyp", string);
                        }
                        SSHMenuHandlerFull.this.client.propsHandler.setProperty("port", SSHMenuHandlerFull.this.textPort.getText());
                        SSHMenuHandlerFull.this.client.propsHandler.setProperty("usrname", SSHMenuHandlerFull.this.textUser.getText());
                        SSHMenuHandlerFull.this.client.propsHandler.setProperty("cipher", SSHMenuHandlerFull.this.cipher[SSHMenuHandlerFull.this.choiceCipher.getSelectedIndex()]);
                        SSHMenuHandlerFull.this.client.propsHandler.setProperty("idfile", SSHMenuHandlerFull.this.textId.getText());
                        SSHMenuHandlerFull.this.client.propsHandler.setProperty("display", SSHMenuHandlerFull.this.textDisp.getText());
                        SSHMenuHandlerFull.this.client.propsHandler.setProperty("mtu", SSHMenuHandlerFull.this.textMtu.getText());
                        SSHMenuHandlerFull.this.client.propsHandler.setProperty("x11fwd", String.valueOf(SSHMenuHandlerFull.this.cbX11.getState()));
                        SSHMenuHandlerFull.this.client.propsHandler.setProperty("prvport", String.valueOf(SSHMenuHandlerFull.this.cbPrvPrt.getState()));
                        SSHMenuHandlerFull.this.client.propsHandler.setProperty("remfwd", String.valueOf(SSHMenuHandlerFull.this.cbRemFwd.getState()));
                        SSHMenuHandlerFull.this.client.propsHandler.setProperty("idhost", String.valueOf(SSHMenuHandlerFull.this.cbIdHost.getState()));
                        SSHMenuHandlerFull.this.client.propsHandler.setProperty("forcpty", String.valueOf(SSHMenuHandlerFull.this.cbForcPty.getState()));
                        SSHMenuHandlerFull.this.client.propsHandler.setProperty("portftp", String.valueOf(SSHMenuHandlerFull.this.cbPortFtp.getState()));
                        SSHMenuHandlerFull.this.client.propsHandler.setProperty("localhst", String.valueOf(SSHMenuHandlerFull.this.textLocHost.getText()));
                        if (SSHMenuHandlerFull.this.cbPortFtp.getState()) {
                            SSHMenuHandlerFull.this.client.propsHandler.setProperty("realsrv", SSHMenuHandlerFull.this.textRealAddr.getText());
                        } else {
                            SSHMenuHandlerFull.this.client.propsHandler.setProperty("realsrv", "");
                        }
                        SSHMenuHandlerFull.this.client.propsHandler.setProperty("alive", SSHMenuHandlerFull.this.textAlive.getText());
                        if (SSHMenuHandlerFull.this.client.propsHandler.savePasswords) {
                            String string3 = SSHMenuHandlerFull.this.setPasswordDialog("Please set password for alias " + string2, "MindTerm - Set File Password");
                            if (string3 == null) {
                                return;
                            }
                            SSHMenuHandlerFull.this.client.propsHandler.setPropertyPassword(string3);
                        }
                        if (SSHMenuHandlerFull.this.newServer) {
                            SSHMenuHandlerFull.this.client.sshStdIO.breakPromptLine("Connecting to: " + string2);
                        }
                        ((Component)SSHMenuHandlerFull.this.settingsDialog).setVisible(false);
                    }
                    catch (Exception exception) {
                        SSHMenuHandlerFull.this.lblAlert.setText(exception.getMessage());
                    }
                }
            });
            Button button3 = new Button("Cancel");
            panel.add(button3);
            button3.addActionListener(new AWTConvenience.CloseAction(this.settingsDialog));
            ((GridBagConstraints)serializable).gridy = 13;
            ((GridBagLayout)object2).setConstraints(panel, (GridBagConstraints)serializable);
            this.settingsDialog.add(panel);
            this.settingsDialog.addWindowListener(new AWTConvenience.CloseAdapter(button3));
            AWTConvenience.setBackgroundOfChildren(this.settingsDialog);
            AWTConvenience.setKeyListenerOfChildren(this.settingsDialog, new AWTConvenience.OKCancelAdapter(button2, button3), null);
            this.settingsDialog.setResizable(true);
            this.settingsDialog.pack();
        }
        if ((object = this.client.propsHandler.getProperty("server")) != null && ((String)object).length() == 0 || !this.client.isConnected) {
            this.textSrv.setEnabled(true);
            this.settingsDialog.setTitle("MindTerm - New Server");
            this.newServer = true;
            this.client.propsHandler.clearServerSetting();
        } else {
            this.textSrv.setEnabled(false);
            this.newServer = false;
            this.settingsDialog.setTitle("MindTerm - SSH Settings: " + this.client.propsHandler.currentAlias);
        }
        this.textSrv.setText((String)object);
        this.textPort.setText(this.client.propsHandler.getProperty("port"));
        this.textUser.setText(this.client.propsHandler.getProperty("usrname"));
        this.choiceCipher.select(this.client.propsHandler.getProperty("cipher"));
        object2 = this.client.propsHandler.getProperty("authtyp");
        if (((String)object2).indexOf(44) == -1) {
            this.choiceAuthTyp.select((String)object2);
        } else {
            this.choiceAuthTyp.select("custom...");
            this.textAuthList.setText((String)object2);
        }
        this.textId.setText(this.client.propsHandler.getProperty("idfile"));
        this.textDisp.setText(this.client.propsHandler.getProperty("display"));
        this.textMtu.setText(this.client.propsHandler.getProperty("mtu"));
        this.textAlive.setText(this.client.propsHandler.getProperty("alive"));
        serializable = this.client.getServerRealAddr();
        if (serializable != null) {
            this.textRealAddr.setText(((InetAddress)serializable).getHostAddress());
        }
        this.cbX11.setState(Boolean.valueOf(this.client.propsHandler.getProperty("x11fwd")));
        this.cbMTU.setState(!this.client.propsHandler.getProperty("mtu").equals("0"));
        this.cbAlive.setState(!this.client.propsHandler.getProperty("alive").equals("0"));
        this.cbLocHst.setState(!this.client.propsHandler.getProperty("localhst").equals("0.0.0.0"));
        this.textLocHost.setEnabled(false);
        this.cbPrvPrt.setState(Boolean.valueOf(this.client.propsHandler.getProperty("prvport")));
        this.cbRemFwd.setState(Boolean.valueOf(this.client.propsHandler.getProperty("remfwd")));
        this.cbIdHost.setState(Boolean.valueOf(this.client.propsHandler.getProperty("idhost")));
        this.cbPortFtp.setState(Boolean.valueOf(this.client.propsHandler.getProperty("portftp")));
        this.cbForcPty.setState(Boolean.valueOf(this.client.propsHandler.getProperty("forcpty")));
        this.updateChoices();
        this.lblAlert.setText("");
        AWTConvenience.placeDialog(this.settingsDialog);
        if (this.textSrv.isEnabled()) {
            this.textSrv.requestFocus();
        } else {
            this.textUser.requestFocus();
        }
        ((Component)this.settingsDialog).setVisible(true);
    }

    void updateChoices() {
        String string = this.choiceAuthTyp.getSelectedItem();
        if (string.equals("rsa") || string.equals("rhostsrsa") || string.equals("custom...")) {
            this.textId.setEnabled(true);
            this.idFileBut.setEnabled(true);
        } else {
            this.textId.setEnabled(false);
            this.idFileBut.setEnabled(false);
        }
        if (string.equals("custom...")) {
            this.textAuthList.setEnabled(true);
        } else {
            this.textAuthList.setEnabled(false);
            this.textAuthList.setText("");
        }
        this.textDisp.setEnabled(this.cbX11.getState());
        this.textMtu.setEnabled(this.cbMTU.getState());
        if (!this.cbMTU.getState()) {
            this.textMtu.setText("0");
        }
        if (!this.textAlive.isEnabled() && this.cbAlive.getState()) {
            this.textAlive.setText("10");
        } else if (!this.textAlive.isEnabled()) {
            this.textAlive.setText("0");
        }
        this.textAlive.setEnabled(this.cbAlive.getState());
        this.textRealAddr.setEnabled(this.cbPortFtp.getState());
        if (this.cbLocHst.getState()) {
            if (!this.textLocHost.isEnabled()) {
                this.textLocHost.setText(this.client.propsHandler.getProperty("localhst"));
            }
        } else {
            this.textLocHost.setText("0.0.0.0");
        }
        this.textLocHost.setEnabled(this.cbLocHst.getState());
    }

    public final void currentTunnelsDialog() {
        if (this.currentTunnelsDialog == null) {
            this.currentTunnelsDialog = new Dialog(this.parent, "MindTerm - Currently Open Tunnels", false);
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.currentTunnelsDialog.setLayout(gridBagLayout);
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(10, 10, 0, 10);
            gridBagConstraints.gridwidth = 2;
            Label label = new Label("Currently open tunnels:");
            gridBagLayout.setConstraints(label, gridBagConstraints);
            this.currentTunnelsDialog.add(label);
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(10, 10, 10, 10);
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 10;
            this.currList = new List(8);
            gridBagLayout.setConstraints(this.currList, gridBagConstraints);
            this.currentTunnelsDialog.add(this.currList);
            Panel panel = new Panel(new FlowLayout());
            Button button = new Button("Close Tunnel");
            panel.add(button);
            button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = SSHMenuHandlerFull.this.currList.getSelectedIndex();
                    if (n == -1) {
                        SSHMenuHandlerFull.this.term.doBell();
                        return;
                    }
                    SSHMenuHandlerFull.this.client.controller.closeTunnelFromList(n);
                    Thread.yield();
                    SSHMenuHandlerFull.this.refreshCurrList();
                }
            });
            button = new Button("Refresh");
            panel.add(button);
            button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SSHMenuHandlerFull.this.refreshCurrList();
                }
            });
            button = new Button("Close Dialog");
            panel.add(button);
            button.addActionListener(new AWTConvenience.CloseAction(this.currentTunnelsDialog));
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 10;
            gridBagLayout.setConstraints(panel, gridBagConstraints);
            this.currentTunnelsDialog.add(panel);
            this.currentTunnelsDialog.addWindowListener(new AWTConvenience.CloseAdapter(button));
            AWTConvenience.setBackgroundOfChildren(this.currentTunnelsDialog);
            this.currentTunnelsDialog.setResizable(true);
            this.currentTunnelsDialog.pack();
        }
        this.refreshCurrList();
        AWTConvenience.placeDialog(this.currentTunnelsDialog);
        this.currList.requestFocus();
        ((Component)this.currentTunnelsDialog).setVisible(true);
    }

    void refreshCurrList() {
        this.currList.removeAll();
        String[] stringArray = this.client.controller.listTunnels();
        int n = 0;
        while (n < stringArray.length) {
            this.currList.add(stringArray[n]);
            ++n;
        }
        if (stringArray.length > 0) {
            this.currList.select(0);
        }
    }

    public final void advancedTunnelsDialog() {
        if (this.tunnelDialog == null) {
            this.tunnelDialog = new Dialog(this.parent, "MindTerm - Advanced Tunnels Setup", true);
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.tunnelDialog.setLayout(gridBagLayout);
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(4, 8, 4, 8);
            gridBagConstraints.gridy = 0;
            this.localEdit = new TunnelEditor("Local: ([/plug/][<loc-host>]:<loc-port>:<rem-host>:<rem-port>)", new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        SSHMenuHandlerFull.this.client.propsHandler.setProperty("local" + SSHMenuHandlerFull.this.client.localForwards.size(), SSHMenuHandlerFull.this.localEdit.getText());
                        SSHMenuHandlerFull.this.updateAdvancedTunnelLists();
                    }
                    catch (Exception exception) {
                        SSHMenuHandlerFull.this.localEdit.selectText();
                    }
                }
            }, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = SSHMenuHandlerFull.this.localEdit.getSelectedIndex();
                    if (n != -1) {
                        SSHMenuHandlerFull.this.client.propsHandler.removeLocalTunnelAt(n, true);
                        SSHMenuHandlerFull.this.updateAdvancedTunnelLists();
                    }
                }
            });
            gridBagLayout.setConstraints(this.localEdit, gridBagConstraints);
            this.tunnelDialog.add(this.localEdit);
            gridBagConstraints.gridy = 1;
            this.remoteEdit = new TunnelEditor("Remote: ([/plug/]<rem-port>:<loc-host>:<loc-port>)", new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        SSHMenuHandlerFull.this.client.propsHandler.setProperty("remote" + SSHMenuHandlerFull.this.client.remoteForwards.size(), SSHMenuHandlerFull.this.remoteEdit.getText());
                        SSHMenuHandlerFull.this.updateAdvancedTunnelLists();
                    }
                    catch (Exception exception) {
                        SSHMenuHandlerFull.this.remoteEdit.selectText();
                    }
                }
            }, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = SSHMenuHandlerFull.this.remoteEdit.getSelectedIndex();
                    if (SSHMenuHandlerFull.this.remoteEdit.getItem(n).indexOf("#FTP") != -1) {
                        return;
                    }
                    if (n != -1) {
                        SSHMenuHandlerFull.this.client.propsHandler.removeRemoteTunnelAt(n);
                        SSHMenuHandlerFull.this.updateAdvancedTunnelLists();
                    }
                }
            });
            gridBagLayout.setConstraints(this.remoteEdit, gridBagConstraints);
            this.tunnelDialog.add(this.remoteEdit);
            Button button = new Button("Close Dialog");
            button.addActionListener(new AWTConvenience.CloseAction(this.tunnelDialog));
            gridBagConstraints.gridy = 2;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.fill = 0;
            gridBagConstraints.weighty = 0.0;
            gridBagLayout.setConstraints(button, gridBagConstraints);
            this.tunnelDialog.add(button);
            this.tunnelDialog.addWindowListener(new AWTConvenience.CloseAdapter(button));
            AWTConvenience.setBackgroundOfChildren(this.tunnelDialog);
            this.tunnelDialog.setResizable(true);
            this.tunnelDialog.pack();
        }
        this.updateAdvancedTunnelLists();
        AWTConvenience.placeDialog(this.tunnelDialog);
        ((Component)this.tunnelDialog).setVisible(true);
    }

    void updateAdvancedTunnelLists() {
        String string;
        Object object;
        this.localEdit.removeAll();
        this.remoteEdit.removeAll();
        int n = 0;
        while (n < this.client.localForwards.size()) {
            object = (SSHClient.LocalForward)this.client.localForwards.elementAt(n);
            string = ((SSHClient.LocalForward)object).plugin.equals("general") ? "" : "/" + ((SSHClient.LocalForward)object).plugin + "/";
            this.localEdit.addToList(string + ((SSHClient.LocalForward)object).localHost + ":" + ((SSHClient.LocalForward)object).localPort + ":" + ((SSHClient.LocalForward)object).remoteHost + ":" + ((SSHClient.LocalForward)object).remotePort);
            ++n;
        }
        n = 0;
        while (n < this.client.remoteForwards.size()) {
            object = (SSHClient.RemoteForward)this.client.remoteForwards.elementAt(n);
            string = ((SSHClient.RemoteForward)object).plugin.equals("general") ? "" : "/" + ((SSHClient.RemoteForward)object).plugin + "/";
            this.remoteEdit.addToList(string + ((SSHClient.RemoteForward)object).remotePort + ":" + ((SSHClient.RemoteForward)object).localHost + ":" + ((SSHClient.RemoteForward)object).localPort);
            ++n;
        }
    }

    public final void connectDialog() {
        Object object;
        if (this.connectDialog == null) {
            this.connectDialog = new Dialog(this.parent, "MindTerm - Connect", true);
            object = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.connectDialog.setLayout((LayoutManager)object);
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(8, 8, 0, 8);
            Label label = new Label("Available hosts/aliases:");
            ((GridBagLayout)object).setConstraints(label, gridBagConstraints);
            this.connectDialog.add(label);
            gridBagConstraints.gridy = 1;
            label = new Label("(dir: " + this.client.propsHandler.getSSHHomeDir() + ")");
            ((GridBagLayout)object).setConstraints(label, gridBagConstraints);
            this.connectDialog.add(label);
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(8, 8, 8, 8);
            gridBagConstraints.gridy = 2;
            this.hostList = new List(8);
            ((GridBagLayout)object).setConstraints(this.hostList, gridBagConstraints);
            this.connectDialog.add(this.hostList);
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = SSHMenuHandlerFull.this.hostList.getSelectedItem();
                    try {
                        String string2 = "";
                        while (true) {
                            try {
                                SSHMenuHandlerFull.this.client.propsHandler.setPropertyPassword(string2);
                                SSHMenuHandlerFull.this.client.propsHandler.loadAliasFile(string, false);
                                SSHMenuHandlerFull.this.client.quiet = true;
                                SSHMenuHandlerFull.this.client.sshStdIO.breakPromptLine("Connecting to: " + string);
                                ((Component)SSHMenuHandlerFull.this.connectDialog).setVisible(false);
                            }
                            catch (SSHClient.AuthFailException authFailException) {
                                if ((string2 = SSHMenuHandlerFull.this.passwordDialog("Please give file password for " + string, "MindTerm - File Password")) != null) continue;
                            }
                            break;
                        }
                    }
                    catch (Throwable throwable) {
                        SSHMenuHandlerFull.this.alertDialog("Error loading settings: " + throwable.getMessage());
                    }
                }
            };
            this.hostList.addActionListener(actionListener);
            Panel panel = new Panel(new FlowLayout());
            Button button = new Button("Connect");
            panel.add(button);
            button.addActionListener(actionListener);
            button = new Button("New Server");
            panel.add(button);
            button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ((Component)SSHMenuHandlerFull.this.connectDialog).setVisible(false);
                    try {
                        SSHMenuHandlerFull.this.client.propsHandler.checkSave();
                    }
                    catch (Throwable throwable) {
                        SSHMenuHandlerFull.this.alertDialog("Error saving settings: " + throwable.getMessage());
                    }
                    SSHMenuHandlerFull.this.client.propsHandler.clearServerSetting();
                    SSHMenuHandlerFull.this.wantToRunSettingsDialog = true;
                    ((Component)SSHMenuHandlerFull.this.connectDialog).setVisible(false);
                }
            });
            button = new Button("Cancel");
            panel.add(button);
            button.addActionListener(new AWTConvenience.CloseAction(this.connectDialog));
            gridBagConstraints.gridy = 4;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = 10;
            ((GridBagLayout)object).setConstraints(panel, gridBagConstraints);
            this.connectDialog.add(panel);
            this.connectDialog.addWindowListener(new AWTConvenience.CloseAdapter(button));
            AWTConvenience.setBackgroundOfChildren(this.connectDialog);
            this.connectDialog.setResizable(true);
            this.connectDialog.pack();
        }
        this.hostList.removeAll();
        object = this.client.propsHandler.availableAliases();
        if (object != null) {
            int n = 0;
            while (n < ((String[])object).length) {
                this.hostList.add(object[n]);
                ++n;
            }
        }
        this.hostList.select(0);
        this.connectDialog.pack();
        AWTConvenience.placeDialog(this.connectDialog);
        this.hostList.requestFocus();
        ((Component)this.connectDialog).setVisible(true);
        if (this.wantToRunSettingsDialog) {
            this.wantToRunSettingsDialog = false;
            this.sshSettingsDialog();
        }
    }

    public final void loadFileDialog() {
        if (this.loadFileDialog == null) {
            this.loadFileDialog = new FileDialog(this.parent, "MindTerm - Select file to load settings from", 0);
        }
        this.loadFileDialog.setDirectory(this.client.propsHandler.getSSHHomeDir());
        ((Component)this.loadFileDialog).setVisible(true);
        String string = this.loadFileDialog.getFile();
        String string2 = this.loadFileDialog.getDirectory();
        if (string != null && string.length() > 0) {
            try {
                String string3 = "";
                while (true) {
                    try {
                        this.client.propsHandler.setPropertyPassword(string3);
                        this.client.propsHandler.loadAbsoluteFile(string2 + string, false);
                        this.client.quiet = true;
                        this.client.sshStdIO.breakPromptLine("Loaded new settings: " + string);
                    }
                    catch (SSHClient.AuthFailException authFailException) {
                        if ((string3 = this.passwordDialog("Please give password for " + string, "MindTerm - File Password")) != null) continue;
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
                this.alertDialog("Error loading settings: " + throwable.getMessage());
            }
        }
    }

    public final void saveAsFileDialog() {
        if (this.saveAsFileDialog == null) {
            this.saveAsFileDialog = new FileDialog(this.parent, "MindTerm - Select file to save settings to", 1);
        }
        this.saveAsFileDialog.setDirectory(this.client.propsHandler.getSSHHomeDir());
        String string = this.client.propsHandler.currentAlias;
        if (string == null) {
            string = this.client.propsHandler.getProperty("server");
        }
        this.saveAsFileDialog.setFile(string + ".mtp");
        ((Component)this.saveAsFileDialog).setVisible(true);
        String string2 = this.saveAsFileDialog.getFile();
        String string3 = this.saveAsFileDialog.getDirectory();
        if (string2 != null && string2.length() > 0) {
            try {
                if (this.client.propsHandler.savePasswords) {
                    String string4 = this.setPasswordDialog("Please set password for " + string2, "MindTerm - Set File Password");
                    if (string4 == null) {
                        return;
                    }
                    this.client.propsHandler.setPropertyPassword(string4);
                }
                this.client.propsHandler.saveAsCurrentFile(string3 + string2);
            }
            catch (Throwable throwable) {
                this.alertDialog("Error saving settings: " + throwable.getMessage());
            }
        }
    }

    public final void sendFileDialog() {
        if (this.sendFileDialog == null) {
            this.sendFileDialog = new FileDialog(this.parent, "MindTerm - Select ASCII-file to send", 0);
        }
        ((Component)this.sendFileDialog).setVisible(true);
        String string = this.sendFileDialog.getFile();
        String string2 = this.sendFileDialog.getDirectory();
        if (string != null && string.length() > 0) {
            try {
                FileInputStream fileInputStream = new FileInputStream(string2 + string);
                byte[] byArray = new byte[fileInputStream.available()];
                fileInputStream.read(byArray);
                String string3 = new String(byArray);
                this.client.stdinWriteString(string3);
            }
            catch (Throwable throwable) {
                this.alertDialog("Error sending file: " + throwable.getMessage());
            }
        }
    }

    public final boolean captureToFileDialog() {
        if (this.captureToFileDialog == null) {
            this.captureToFileDialog = new FileDialog(this.parent, "MindTerm - Select file to capture to", 1);
        }
        ((Component)this.captureToFileDialog).setVisible(true);
        String string = this.captureToFileDialog.getFile();
        String string2 = this.captureToFileDialog.getDirectory();
        if (string != null && string.length() > 0) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(string2 + string, true);
                this.captureConsole = new SSHCaptureConsole(this.client, fileOutputStream);
                return true;
            }
            catch (Throwable throwable) {
                this.alertDialog("Error in capture: " + throwable.getMessage());
            }
        }
        return false;
    }

    public void endCapture() {
        if (this.captureConsole != null) {
            this.captureConsole.endCapture();
            this.captureConsole = null;
        }
    }

    public void keyGenerationDialog() {
        if (this.keyGenerationDialog == null) {
            this.keyGenerationDialog = new Dialog(this.parent, "MindTerm - RSA Key Generation", true);
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.keyGenerationDialog.setLayout(gridBagLayout);
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridwidth = 12;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(8, 8, 8, 8);
            int n = 18;
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            if (dimension.height < 600) {
                n = 8;
            }
            this.descText = new TextArea(keyGenerationHelp, n, 48, 1);
            MouseMotionAdapter mouseMotionAdapter = new MouseMotionAdapter(){

                public void mouseMoved(MouseEvent mouseEvent) {
                    ++SSHMenuHandlerFull.this.dummy;
                    if (SSHMenuHandlerFull.this.randCnt < 256) {
                        if (SSHMenuHandlerFull.this.dummy % 2 == 0) {
                            SSHMenuHandlerFull.this.randBytes[SSHMenuHandlerFull.this.randCnt++] = SSHMenuHandlerFull.this.randCnt % 2 == 0 ? (byte)mouseEvent.getX() : (byte)mouseEvent.getY();
                            SSHMenuHandlerFull.this.progBar.setValue(SSHMenuHandlerFull.this.randCnt);
                        }
                    } else {
                        SSHMenuHandlerFull.this.okBut.setEnabled(true);
                    }
                }
            };
            this.descText.addMouseMotionListener(mouseMotionAdapter);
            gridBagLayout.setConstraints(this.descText, gridBagConstraints);
            this.keyGenerationDialog.add(this.descText);
            this.descText.setEditable(false);
            gridBagConstraints.gridy = 1;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 10;
            this.progBar = new ProgressBar(256, 150, 20);
            gridBagLayout.setConstraints(this.progBar, gridBagConstraints);
            this.keyGenerationDialog.add(this.progBar);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(4, 4, 0, 0);
            gridBagConstraints.gridwidth = 4;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.weightx = 0.0;
            Label label = new Label("Keylength (bits):");
            gridBagLayout.setConstraints(label, gridBagConstraints);
            this.keyGenerationDialog.add(label);
            this.bitsText = new TextField("", 5);
            gridBagConstraints.weightx = 1.0;
            gridBagLayout.setConstraints(this.bitsText, gridBagConstraints);
            this.keyGenerationDialog.add(this.bitsText);
            gridBagConstraints.gridy = 3;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.0;
            label = new Label("Identity file:");
            gridBagLayout.setConstraints(label, gridBagConstraints);
            this.keyGenerationDialog.add(label);
            this.fileText = new TextField("", 18);
            gridBagConstraints.weightx = 1.0;
            gridBagLayout.setConstraints(this.fileText, gridBagConstraints);
            this.keyGenerationDialog.add(this.fileText);
            Button button = new Button("...");
            button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (SSHMenuHandlerFull.this.keyGenFD == null) {
                        SSHMenuHandlerFull.this.keyGenFD = new FileDialog(SSHMenuHandlerFull.this.parent, "MindTerm - Select file to save identity to", 1);
                        SSHMenuHandlerFull.this.keyGenFD.setDirectory(SSHMenuHandlerFull.this.client.propsHandler.getSSHHomeDir());
                    }
                    ((Component)SSHMenuHandlerFull.this.keyGenFD).setVisible(true);
                    if (SSHMenuHandlerFull.this.keyGenFD.getFile() != null && SSHMenuHandlerFull.this.keyGenFD.getFile().length() > 0) {
                        SSHMenuHandlerFull.this.fileText.setText(SSHMenuHandlerFull.this.keyGenFD.getDirectory() + SSHMenuHandlerFull.this.keyGenFD.getFile());
                    }
                }
            });
            gridBagConstraints.fill = 0;
            gridBagLayout.setConstraints(button, gridBagConstraints);
            this.keyGenerationDialog.add(button);
            gridBagConstraints.gridy = 4;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.0;
            label = new Label("Password:");
            gridBagLayout.setConstraints(label, gridBagConstraints);
            this.keyGenerationDialog.add(label);
            this.pwdText = new TextField("", 18);
            this.pwdText.setEchoChar('*');
            gridBagConstraints.weightx = 1.0;
            gridBagLayout.setConstraints(this.pwdText, gridBagConstraints);
            this.keyGenerationDialog.add(this.pwdText);
            gridBagConstraints.gridy = 5;
            gridBagConstraints.weightx = 0.0;
            label = new Label("Password again:");
            gridBagLayout.setConstraints(label, gridBagConstraints);
            this.keyGenerationDialog.add(label);
            this.pwdText2 = new TextField("", 18);
            this.pwdText2.setEchoChar('*');
            gridBagConstraints.weightx = 1.0;
            gridBagLayout.setConstraints(this.pwdText2, gridBagConstraints);
            this.keyGenerationDialog.add(this.pwdText2);
            gridBagConstraints.gridy = 6;
            gridBagConstraints.weightx = 0.0;
            label = new Label("Comment:");
            gridBagLayout.setConstraints(label, gridBagConstraints);
            this.keyGenerationDialog.add(label);
            this.commText = new TextField("", 18);
            gridBagConstraints.weightx = 1.0;
            gridBagLayout.setConstraints(this.commText, gridBagConstraints);
            this.keyGenerationDialog.add(this.commText);
            gridBagConstraints.gridy = 7;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.insets = new Insets(8, 4, 0, 0);
            this.useCheck = new Checkbox("Use key in current session");
            gridBagLayout.setConstraints(this.useCheck, gridBagConstraints);
            this.keyGenerationDialog.add(this.useCheck);
            gridBagConstraints.gridy = 8;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.gridwidth = 4;
            this.msgLbl = new Label("", 1);
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 10;
            gridBagLayout.setConstraints(this.msgLbl, gridBagConstraints);
            this.keyGenerationDialog.add(this.msgLbl);
            gridBagConstraints.gridy = 9;
            Panel panel = new Panel(new FlowLayout());
            this.okBut = new Button("Generate");
            panel.add(this.okBut);
            this.okBut.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Object object;
                    int n;
                    String string = SSHMenuHandlerFull.this.pwdText.getText();
                    String string2 = SSHMenuHandlerFull.this.fileText.getText();
                    String string3 = SSHMenuHandlerFull.this.commText.getText();
                    try {
                        n = Integer.valueOf(SSHMenuHandlerFull.this.bitsText.getText());
                        if (n < 512 || n > 2048) {
                            SSHMenuHandlerFull.this.msgLbl.setText("Keylength must be in interval 512-2048");
                            return;
                        }
                    }
                    catch (Exception exception) {
                        SSHMenuHandlerFull.this.msgLbl.setText("Keylength must be an integer");
                        return;
                    }
                    if (!string.equals(SSHMenuHandlerFull.this.pwdText2.getText())) {
                        SSHMenuHandlerFull.this.msgLbl.setText("Please give same password twice");
                        return;
                    }
                    try {
                        if (string2.length() == 0) {
                            throw new Exception();
                        }
                        if (string2.indexOf(File.separator) == -1) {
                            string2 = SSHMenuHandlerFull.this.client.propsHandler.getSSHHomeDir() + string2;
                        }
                        object = new FileOutputStream(string2);
                        ((FileOutputStream)object).close();
                    }
                    catch (Exception exception) {
                        SSHMenuHandlerFull.this.msgLbl.setText("File can't be written to, please check");
                        return;
                    }
                    SSHMenuHandlerFull.this.keyGenerationDialog.remove(SSHMenuHandlerFull.this.msgLbl);
                    SSHMenuHandlerFull.this.msgLbl.setText("Please wait while generating key...");
                    SSHMenuHandlerFull.this.keyGenerationDialog.add(SSHMenuHandlerFull.this.msgLbl);
                    SSHMenuHandlerFull.this.okBut.setEnabled(false);
                    try {
                        object = SSH.generateKeyFiles(SSH.generateRSAKeyPair(n, new SecureRandom(SSHMenuHandlerFull.this.randBytes)), string2, string, string3);
                        SSHMenuHandlerFull.this.client.sshStdIO.setSelection((String)object);
                        SSHMenuHandlerFull.this.client.sshStdIO.selectionAvailable(true);
                        SSHMenuHandlerFull.this.msgLbl.setText("");
                        SSHMenuHandlerFull.this.alertDialog("Key is now generated and saved to file and clipboard");
                        if (SSHMenuHandlerFull.this.useCheck.getState()) {
                            SSHMenuHandlerFull.this.client.propsHandler.setProperty("idfile", string2);
                        }
                    }
                    catch (IOException iOException) {
                        SSHMenuHandlerFull.this.alertDialog("Error saving identity: " + iOException.getMessage());
                        SSHMenuHandlerFull.this.msgLbl.setText("An error occured while saving identity");
                    }
                    SSHMenuHandlerFull.this.pwdText.setText("");
                    SSHMenuHandlerFull.this.pwdText2.setText("");
                    SSHMenuHandlerFull.this.randCnt = 0;
                    SSHMenuHandlerFull.this.dummy = 0;
                    SSHMenuHandlerFull.this.progBar.setValue(0);
                    SSHMenuHandlerFull.this.setDefaultFileName();
                }
            });
            button = new Button("Close");
            panel.add(button);
            button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SSHMenuHandlerFull.this.randCnt = 0;
                    SSHMenuHandlerFull.this.dummy = 0;
                    ((Component)SSHMenuHandlerFull.this.keyGenerationDialog).setVisible(false);
                    SSHMenuHandlerFull.this.pwdText.setText("");
                    SSHMenuHandlerFull.this.pwdText2.setText("");
                }
            });
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 10;
            gridBagLayout.setConstraints(panel, gridBagConstraints);
            this.keyGenerationDialog.add(panel);
            this.keyGenerationDialog.addWindowListener(new AWTConvenience.CloseAdapter(button));
            AWTConvenience.setBackgroundOfChildren(this.keyGenerationDialog);
            this.keyGenerationDialog.setResizable(true);
            this.keyGenerationDialog.pack();
        }
        this.useCheck.setState(true);
        this.msgLbl.setText("");
        this.okBut.setEnabled(false);
        this.bitsText.setText("1024");
        this.progBar.setValue(0);
        this.setDefaultFileName();
        AWTConvenience.placeDialog(this.keyGenerationDialog);
        this.bitsText.requestFocus();
        ((Component)this.keyGenerationDialog).setVisible(true);
    }

    void setDefaultFileName() {
        try {
            String string = this.client.propsHandler.getSSHHomeDir() + "identity";
            File file = new File(string);
            int n = 0;
            while (file.exists()) {
                string = this.client.propsHandler.getSSHHomeDir() + "identity" + n;
                file = new File(string);
                ++n;
            }
            this.fileText.setText("identity" + (--n >= 0 ? String.valueOf(n) : ""));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public final void alertDialog(String string) {
        SSHMiscDialogs.alert("MindTerm - Alert", string, this.parent);
    }

    public final String passwordDialog(String string, String string2) {
        return SSHMiscDialogs.password(string2, string, this.parent);
    }

    public final String setPasswordDialog(String string, String string2) {
        return SSHMiscDialogs.setPassword(string2, string, this.parent);
    }

    public final boolean confirmDialog(String string, boolean bl) {
        return SSHMiscDialogs.confirm("MindTerm - Confirmation", string, bl, this.parent);
    }

    public final void textDialog(String string, String string2, int n, int n2, boolean bl) {
        SSHMiscDialogs.notice(string, string2, n, n2, bl, this.parent);
    }

    protected class TunnelEditor
    extends Panel {
        List list;
        TextField text;

        public TunnelEditor(String string, ActionListener actionListener, ActionListener actionListener2) {
            super(new BorderLayout(5, 5));
            this.add((Component)new Label(string), "North");
            this.list = new List(5, false);
            this.add((Component)this.list, "Center");
            Panel panel = new Panel(new FlowLayout());
            this.text = new TextField("", 26);
            panel.add(this.text);
            Button button = new Button("Add");
            panel.add(button);
            button.addActionListener(actionListener);
            button = new Button("Delete");
            panel.add(button);
            button.addActionListener(actionListener2);
            this.add((Component)panel, "South");
            this.list.addActionListener(new ActionListener(this){
                private final /* synthetic */ TunnelEditor this$1;
                {
                    this.this$1 = tunnelEditor;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.text.setText(this.this$1.list.getSelectedItem());
                    this.this$1.text.requestFocus();
                }
            });
        }

        public int getItemCount() {
            return this.list.getItemCount();
        }

        public String getItem(int n) {
            return this.list.getItem(n);
        }

        public void addToList(String string) {
            this.list.add(string);
        }

        public int getSelectedIndex() {
            return this.list.getSelectedIndex();
        }

        public void selectText() {
            this.text.selectAll();
        }

        public String getText() {
            return this.text.getText();
        }

        public void removeAll() {
            this.list.removeAll();
        }
    }
}

